/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;
import weka.gui.streams.Messages;
import weka.gui.streams.SerialInstanceListener;

public class InstanceJoiner
implements Serializable,
InstanceProducer,
SerialInstanceListener {
    private static final long serialVersionUID = -6529972700291329656L;
    private Vector listeners = new Vector();
    private boolean b_Debug = false;
    protected Instances m_InputFormat = null;
    private Instance m_OutputInstance = null;
    private boolean b_FirstInputFinished = false;
    private boolean b_SecondInputFinished = false;

    public boolean inputFormat(Instances instanceInfo) {
        this.m_InputFormat = new Instances(instanceInfo, 0);
        this.notifyInstanceProduced(new InstanceEvent(this, 1));
        this.b_FirstInputFinished = false;
        this.b_SecondInputFinished = false;
        return true;
    }

    public Instances outputFormat() throws Exception {
        if (this.m_InputFormat == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("InstanceJoiner_OutputFormat_Exception_Text"));
        }
        return new Instances(this.m_InputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("InstanceJoiner_Input_Exception_Text"));
        }
        if (instance != null) {
            this.m_OutputInstance = (Instance)instance.copy();
            this.notifyInstanceProduced(new InstanceEvent(this, 2));
            return true;
        }
        return false;
    }

    public void batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("InstanceJoiner_BatchFinished_Exception_Text"));
        }
        this.notifyInstanceProduced(new InstanceEvent(this, 3));
    }

    public Instance outputPeek() throws Exception {
        if (this.m_InputFormat == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("InstanceJoiner_OutputPeek_Exception_Text"));
        }
        if (this.m_OutputInstance == null) {
            return null;
        }
        return (Instance)this.m_OutputInstance.copy();
    }

    public void setDebug(boolean debug) {
        this.b_Debug = debug;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    public synchronized void addInstanceListener(InstanceListener ipl) {
        this.listeners.addElement(ipl);
    }

    public synchronized void removeInstanceListener(InstanceListener ipl) {
        this.listeners.removeElement(ipl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceProduced(InstanceEvent e) {
        if (this.listeners.size() > 0) {
            Vector l;
            if (this.b_Debug) {
                StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_NotifyInstanceProduced_Error_Text_First")).toString());
            }
            InstanceJoiner instanceJoiner = this;
            synchronized (instanceJoiner) {
                l = (Vector)this.listeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.elementAt(i)).instanceProduced(e);
            }
            try {
                if (e.getID() == 2) {
                    this.m_OutputInstance = null;
                }
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_NotifyInstanceProduced_Exception_Text")).append(ex.getMessage()).toString());
            }
        }
    }

    public void instanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_InstanceProduced_InstanceEventFORMAT_AVAILABLE_Error_Text")).toString());
                        }
                        this.inputFormat(a.outputFormat());
                        break;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_InstanceProduced_InstanceEventINSTANCE_AVAILABLE_Error_Text")).toString());
                        }
                        this.input(a.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_InstanceProduced_InstanceEventBATCH_FINISHED_Error_Text")).toString());
                        }
                        this.batchFinished();
                        this.b_FirstInputFinished = true;
                        break;
                    }
                    default: {
                        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_InstanceProduced_InstanceEventDEFAULT_Error_Text")).toString());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_InstanceProduced_InstanceEventDEFAULT_Error_Text")).toString());
        }
    }

    public void secondInstanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                if (!this.b_FirstInputFinished) {
                    StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                    Messages.getInstance();
                    throw new Exception(stringBuilder.append(Messages.getString("InstanceJoiner_InstanceProduced_Error_Text")).toString());
                }
                InstanceProducer a = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_SecondInstanceProduced_Error_Text_First")).toString());
                        }
                        if (!a.outputFormat().equalHeaders(this.outputFormat())) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            throw new Exception(stringBuilder.append(Messages.getString("InstanceJoiner_SecondInstanceProduced_InstanceEventFORMAT_AVAILABLE_Error_Text")).toString());
                        }
                        break;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_SecondInstanceProduced_InstanceEventINSTANCE_AVAILABLE_Error_Text")).toString());
                        }
                        this.input(a.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_SecondInstanceProduced_InstanceEventBATCH_FINISHED_Error_Text")).toString());
                        }
                        this.batchFinished();
                        break;
                    }
                    default: {
                        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_SecondInstanceProduced_InstanceEventDEFAULT_Error_Text")).toString());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName());
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("InstanceJoiner_SecondInstanceProduced_Error_Text_Second")).toString());
        }
    }
}

