/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.datatypes;

import jcolibri.connector.TypeAdaptor;
import jcolibri.exception.OntologyAccessException;
import jcolibri.util.OntoBridgeSingleton;
import org.apache.commons.logging.LogFactory;

public class Instance
implements TypeAdaptor {
    private String name;
    private boolean useShortName = true;

    public static Instance createInstance(String instanceName, String parentConcept) {
        try {
            OntoBridgeSingleton.getOntoBridge().createInstance(parentConcept, instanceName);
            return new Instance(instanceName);
        }
        catch (OntologyAccessException e) {
            LogFactory.getLog(Instance.class).error((Object)e);
            return null;
        }
    }

    public Instance() {
    }

    public Instance(String instance, boolean useShortName) throws OntologyAccessException {
        this.useShortName = useShortName;
        this.fromString(instance);
    }

    public Instance(String instance) throws OntologyAccessException {
        this.fromString(instance);
    }

    public void fromString(String content) throws OntologyAccessException {
        this.name = this.getCorrectRepresentation(content);
        if (!OntoBridgeSingleton.getOntoBridge().existsInstance(this.name)) {
            throw new OntologyAccessException("Instance: " + this.name + " not found in loaded ontologies. Check names or OntoBridge configuration.");
        }
    }

    public String toString() {
        return this.getCorrectRepresentation(this.name);
    }

    public boolean equals(Object o) {
        String myName;
        if (!(o instanceof Instance)) {
            return false;
        }
        Instance i = (Instance)o;
        String otherName = i.name;
        if (this.isShort(otherName)) {
            otherName = OntoBridgeSingleton.getOntoBridge().getURI(otherName);
        }
        if (this.isShort(myName = this.name)) {
            myName = OntoBridgeSingleton.getOntoBridge().getURI(myName);
        }
        return myName.equals(otherName);
    }

    public int hashCode() {
        return OntoBridgeSingleton.getOntoBridge().getURI(this.name).hashCode();
    }

    public void useShortName(boolean yesno) {
        this.useShortName = yesno;
    }

    private String getCorrectRepresentation(String n) {
        if (this.useShortName) {
            if (!this.isShort(n)) {
                return OntoBridgeSingleton.getOntoBridge().getShortName(n);
            }
        } else if (this.isShort(n)) {
            return OntoBridgeSingleton.getOntoBridge().getURI(n);
        }
        return n;
    }

    private boolean isShort(String n) {
        return n.indexOf(35) == -1;
    }
}

