/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.maintenance_evaluation;

import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.maintenance_evaluation.DetailedEvaluationReport;
import jcolibri.method.maintenance.AbstractCaseBaseEditMethod;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import org.apache.commons.logging.LogFactory;

public abstract class MaintenanceEvaluator
extends Evaluator {
    protected StandardCBRApplication app;
    protected AbstractCaseBaseEditMethod editMethod = null;
    protected KNNClassificationConfig simConfig = null;
    public static final String PERCENT_REDUCED = "Percent reduced";

    public void init(StandardCBRApplication cbrApp) {
        if (report == null || !(report instanceof DetailedEvaluationReport)) {
            report = new DetailedEvaluationReport();
        }
        this.app = cbrApp;
        try {
            this.app.configure();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void init(StandardCBRApplication cbrApp, AbstractCaseBaseEditMethod editMethod, KNNClassificationConfig simConfig) {
        this.init(cbrApp);
        this.setEditMethod(editMethod);
        this.setSimConfig(simConfig);
    }

    public void setEditMethod(AbstractCaseBaseEditMethod editMethod) {
        this.editMethod = editMethod;
    }

    public void setSimConfig(KNNClassificationConfig simConfig) {
        this.simConfig = simConfig;
    }

    protected void editCaseBase(CBRCaseBase caseBase) {
        int sizeBefore = caseBase.getCases().size();
        LogFactory.getLog(this.getClass()).info((Object)"Editing Case-Base");
        this.editMethod.edit(caseBase, this.simConfig);
        LogFactory.getLog(this.getClass()).info((Object)"Finished Editing Case-Base");
        int sizeAfter = caseBase.getCases().size();
        double percentReduced = (double)(sizeBefore - sizeAfter) / (double)sizeBefore * 100.0;
        report.addDataToSeries(PERCENT_REDUCED, percentReduced);
    }
}

