/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.collaborative;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jcolibri.cbrcore.Attribute;
import jcolibri.extensions.recommendation.collaborative.MatrixCaseBase;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PearsonMatrixCaseBase
extends MatrixCaseBase {
    int minCorrelateItemsFactor;
    private HashMap<Integer, Collection<MatrixCaseBase.SimilarTuple>> similLists;
    private HashMap<Integer, HashMap<Integer, Double>> similarities;
    private HashMap<Integer, Double> averages;

    public PearsonMatrixCaseBase(Attribute value, int minCorrelateItemsFactor) {
        super(value);
        this.minCorrelateItemsFactor = minCorrelateItemsFactor;
    }

    @Override
    protected void computeSimilarities() {
        this.computeAverages();
        this.computeSimilarityByDescriptionId();
        this.computeSimilarityLists();
    }

    private void computeSimilarityLists() {
        this.similLists = new HashMap();
        for (Integer key : this.similarities.keySet()) {
            ArrayList<MatrixCaseBase.SimilarTuple> list = new ArrayList<MatrixCaseBase.SimilarTuple>();
            HashMap<Integer, Double> similMap = this.similarities.get(key);
            for (Map.Entry<Integer, Double> entry : similMap.entrySet()) {
                list.add(new MatrixCaseBase.SimilarTuple(this, entry.getKey(), entry.getValue()));
            }
            Collections.sort(list);
            this.similLists.put(key, list);
        }
    }

    @Override
    public Collection<MatrixCaseBase.SimilarTuple> getSimilar(Integer id) {
        return this.similLists.get(id);
    }

    @Override
    public double getSimil(Integer id1, Integer id2) {
        return this.similarities.get(id1).get(id2);
    }

    private void computeSimilarityByDescriptionId() {
        LogFactory.getLog(this.getClass()).info((Object)"Computing similarities");
        this.similarities = new HashMap();
        HashSet keyCopy = new HashSet(this.byDescriptionId.keySet());
        for (Integer me : this.byDescriptionId.keySet()) {
            keyCopy.remove(me);
            for (Integer you : keyCopy) {
                HashMap<Integer, Double> mySimilList;
                MatrixCaseBase.CommonRatingsIterator ratings = new MatrixCaseBase.CommonRatingsIterator(this, me, you, (Collection)this.byDescriptionId.get(me), (Collection)this.byDescriptionId.get(you));
                double sumX = 0.0;
                double sumXSquared = 0.0;
                double sumY = 0.0;
                double sumYSquared = 0.0;
                double sumXY = 0.0;
                double numDataPoints = 0.0;
                while (ratings.hasNext()) {
                    MatrixCaseBase.CommonRatingTuple rt = (MatrixCaseBase.CommonRatingTuple)ratings.next();
                    double x = rt.getRating1();
                    double y = rt.getRating2();
                    numDataPoints += 1.0;
                    sumX += x;
                    sumY += y;
                    sumXSquared += PearsonMatrixCaseBase.square(x);
                    sumYSquared += PearsonMatrixCaseBase.square(y);
                    sumXY += x * y;
                }
                double correlation = 0.0;
                if (numDataPoints != 0.0) {
                    double numerator = sumXY - sumX * sumY / numDataPoints;
                    double sqrt = (sumXSquared - PearsonMatrixCaseBase.square(sumX) / numDataPoints) * (sumYSquared - PearsonMatrixCaseBase.square(sumY) / numDataPoints);
                    double denominator = Math.sqrt(sqrt);
                    correlation = denominator == 0.0 || sqrt < 0.0 ? 0.0 : numerator / denominator;
                    correlation = correlation * numDataPoints / (double)this.minCorrelateItemsFactor;
                }
                if ((mySimilList = this.similarities.get(me)) == null) {
                    mySimilList = new HashMap();
                    this.similarities.put(me, mySimilList);
                }
                mySimilList.put(you, correlation);
                HashMap<Integer, Double> yourSimilList = this.similarities.get(you);
                if (yourSimilList == null) {
                    yourSimilList = new HashMap();
                    this.similarities.put(you, yourSimilList);
                }
                yourSimilList.put(me, correlation);
            }
        }
    }

    private void computeAverages() {
        LogFactory.getLog(this.getClass()).info((Object)"Computing Averages");
        this.averages = new HashMap();
        for (Integer i : this.byDescriptionId.keySet()) {
            ArrayList list = (ArrayList)this.byDescriptionId.get(i);
            double acum = 0.0;
            for (MatrixCaseBase.RatingTuple rt : list) {
                acum += rt.getRating();
            }
            double size = list.size();
            this.averages.put(i, acum / size);
        }
    }

    public double getAverage(int id) {
        return this.averages.get(id);
    }

    private static double square(double n) {
        return n * n;
    }
}

