/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.navigationByAsking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.navigationByAsking.SelectAttributeMethod;
import jcolibri.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationGain
implements SelectAttributeMethod {
    private static ArrayList<Attribute> asked;
    private Collection<CBRCase> completeSetOfCases;

    public static Attribute getMoreIGattribute(Collection<CBRCase> cases, boolean init, Collection<CBRCase> completeSetOfCases) throws ExecutionException {
        if (cases.isEmpty()) {
            cases.addAll(completeSetOfCases);
            init = true;
        }
        if (init) {
            asked = new ArrayList();
        }
        if (asked == null) {
            throw new ExecutionException("InformationGain method must be initialized each cycle");
        }
        CBRCase acase = cases.iterator().next();
        Collection<Attribute> atts = AttributeUtils.getAttributes(acase.getDescription());
        atts.remove(acase.getDescription().getIdAttribute());
        atts.removeAll(asked);
        if (atts.isEmpty()) {
            asked = new ArrayList();
            atts = AttributeUtils.getAttributes(acase.getDescription());
            atts.remove(acase.getDescription().getIdAttribute());
        }
        System.out.println("Computing IG for " + cases.size() + " cases");
        double maxIG = 0.0;
        Attribute maxIGatt = null;
        for (Attribute a : atts) {
            double ig = InformationGain.computeIG(a, cases);
            System.out.println("IG " + a.getName() + " --> " + ig);
            if (!(ig > maxIG)) continue;
            maxIG = ig;
            maxIGatt = a;
        }
        asked.add(maxIGatt);
        return maxIGatt;
    }

    private static double computeIG(Attribute a, Collection<CBRCase> cases) {
        Hashtable<Object, HashSet<CBRCase>> clases = new Hashtable<Object, HashSet<CBRCase>>();
        for (CBRCase c : cases) {
            Object value = AttributeUtils.findValue(a, c.getDescription());
            HashSet<CBRCase> set = (HashSet<CBRCase>)clases.get(value);
            if (set == null) {
                set = new HashSet<CBRCase>();
                clases.put(value, set);
            }
            set.add(c);
        }
        double casesSize = cases.size();
        double res = 0.0;
        Enumeration en = clases.elements();
        while (en.hasMoreElements()) {
            double setSize = ((HashSet)en.nextElement()).size();
            double div = setSize / casesSize;
            res += div * (Math.log(div) / Math.log(2.0));
        }
        return -res;
    }

    public InformationGain(Collection<CBRCase> completeset) {
        this.completeSetOfCases = completeset;
        asked = new ArrayList();
    }

    @Override
    public Attribute getAttribute(Collection<CBRCase> cases, CBRQuery query) throws ExecutionException {
        return InformationGain.getMoreIGattribute(cases, false, this.completeSetOfCases);
    }
}

