/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.navigationByProposing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.extensions.recommendation.casesDisplay.utils.RadioButtonEditor;
import jcolibri.extensions.recommendation.casesDisplay.utils.RadioButtonTableRenderer;
import jcolibri.extensions.recommendation.navigationByAsking.ObtainQueryWithAttributeQuestionMethod;
import jcolibri.extensions.recommendation.navigationByProposing.CriticalUserChoice;
import jcolibri.extensions.recommendation.navigationByProposing.CritiqueOption;
import jcolibri.method.gui.utils.WindowUtils;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.FilterPredicate;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayCasesTableWithCritiquesMethod {
    private static JDialog dialog;
    private static ButtonGroup group;
    private static int returnCode;
    private static Collection<CBRCase> displayedCases;
    private static Collection<CritiqueOption> displayedCritiques;
    private static Collection<CBRCase> _availableCases;
    private static Collection<CritiqueOption> userCritiques;
    private static JTable table;
    private static HashMap<CritiqueOption, JButton> critiquesMap;
    private static CBRCase critiquedQuery;

    static {
        returnCode = -1;
    }

    public static CriticalUserChoice displayCasesInTableWithCritiques(Collection<CBRCase> cases, Collection<CritiqueOption> critiques, Collection<CBRCase> availableCases) {
        displayedCases = cases;
        displayedCritiques = critiques;
        _availableCases = availableCases;
        critiquesMap = new HashMap();
        dialog = new JDialog();
        dialog.setTitle(String.valueOf(cases.size()) + " Retrieved cases");
        dialog.setModal(true);
        userCritiques = new ArrayList<CritiqueOption>();
        Vector<Object> columnNames = DisplayCasesTableWithCritiquesMethod.extractColumnNames(cases.iterator().next());
        Vector<Vector> rows = new Vector<Vector>();
        for (CBRCase c : cases) {
            rows.add(DisplayCasesTableWithCritiquesMethod.getAttributes(c));
        }
        table = new JTable(rows, (Vector)columnNames){
            private static final long serialVersionUID = 1L;

            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        table.getColumn("Select").setCellRenderer(new RadioButtonTableRenderer());
        table.getColumn("Select").setCellEditor(new RadioButtonEditor(new JCheckBox()));
        group = new ButtonGroup();
        TableModel tm = table.getModel();
        int i = 0;
        while (i < tm.getRowCount()) {
            DisplayCasesTableWithCritiquesMethod any;
            JRadioButton rb = (JRadioButton)tm.getValueAt(i, 0);
            group.add(rb);
            DisplayCasesTableWithCritiquesMethod displayCasesTableWithCritiquesMethod = any = new DisplayCasesTableWithCritiquesMethod();
            displayCasesTableWithCritiquesMethod.getClass();
            rb.addActionListener(displayCasesTableWithCritiquesMethod.new ItemRadioButtonListener(i));
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout(new BoxLayout(actionsPanel, 0));
        JButton ok = new JButton("Add to Basket");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (table.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(dialog, "You should choose one item", "Error", 0);
                } else {
                    returnCode = -3;
                    Iterator iter = displayedCases.iterator();
                    CBRCase _case = (CBRCase)iter.next();
                    int i = 0;
                    while (i < table.getSelectedRow()) {
                        _case = (CBRCase)iter.next();
                        ++i;
                    }
                    critiquedQuery = _case;
                    dialog.setVisible(false);
                }
            }
        });
        JButton quit = new JButton("Quit");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                returnCode = -1;
                dialog.setVisible(false);
            }
        });
        actionsPanel.add(Box.createHorizontalGlue());
        actionsPanel.add(ok);
        actionsPanel.add(quit);
        actionsPanel.add(Box.createHorizontalGlue());
        JPanel critiquesPanel = new JPanel();
        critiquesPanel.setLayout(new BoxLayout(critiquesPanel, 0));
        critiquesPanel.add(Box.createHorizontalGlue());
        for (CritiqueOption critique : critiques) {
            DisplayCasesTableWithCritiquesMethod any;
            JButton b = new JButton(critique.getLabel());
            DisplayCasesTableWithCritiquesMethod displayCasesTableWithCritiquesMethod = any = new DisplayCasesTableWithCritiquesMethod();
            displayCasesTableWithCritiquesMethod.getClass();
            b.addActionListener(displayCasesTableWithCritiquesMethod.new CritiqueButtonAction(critique));
            critiquesMap.put(critique, b);
            critiquesPanel.add(b);
            critiquesPanel.add(Box.createHorizontalGlue());
        }
        critiquesPanel.setBorder(BorderFactory.createTitledBorder("Critiques"));
        JPanel south = new JPanel();
        south.setLayout(new BoxLayout(south, 1));
        south.add(actionsPanel);
        south.add(critiquesPanel);
        mainPanel.add((Component)south, "South");
        dialog.getContentPane().add(mainPanel);
        dialog.setSize(800, 600);
        WindowUtils.centerWindow(dialog);
        System.out.println("Available cases:");
        for (CBRCase c : _availableCases) {
            System.out.println(c);
        }
        dialog.setVisible(true);
        return new CriticalUserChoice(returnCode, userCritiques, critiquedQuery);
    }

    private static void disableCritiques(int row) {
        Iterator<CBRCase> iter = displayedCases.iterator();
        CBRCase _case = iter.next();
        int i = 0;
        while (i < row) {
            _case = iter.next();
            ++i;
        }
        for (CritiqueOption co : displayedCritiques) {
            FilterPredicate fp = co.getPredicate();
            Attribute a = co.getAttribute();
            Object valueSelected = AttributeUtils.findValue(a, _case.getDescription());
            boolean therearemore = false;
            for (CBRCase cbCase : _availableCases) {
                Object valueOther = AttributeUtils.findValue(a, cbCase);
                try {
                    boolean res = fp.compute(valueOther, valueSelected);
                    if (fp instanceof Equal) {
                        boolean bl = res = !res;
                    }
                    if (!res) continue;
                    therearemore = true;
                    break;
                }
                catch (Exception e) {
                    LogFactory.getLog(DisplayCasesTableWithCritiquesMethod.class).error((Object)e);
                }
            }
            critiquesMap.get(co).setEnabled(therearemore);
        }
    }

    private static Vector getAttributes(CBRCase c) {
        Vector<Object> res = new Vector<Object>();
        JRadioButton rb = new JRadioButton(c.getID().toString());
        res.add(rb);
        DisplayCasesTableWithCritiquesMethod.getAttributes(c.getDescription(), res);
        DisplayCasesTableWithCritiquesMethod.getAttributes(c.getSolution(), res);
        DisplayCasesTableWithCritiquesMethod.getAttributes(c.getJustificationOfSolution(), res);
        DisplayCasesTableWithCritiquesMethod.getAttributes(c.getResult(), res);
        return res;
    }

    private static void getAttributes(CaseComponent cc, Vector<Object> res) {
        Collection<Attribute> atts = AttributeUtils.getAttributes(cc);
        if (atts == null) {
            return;
        }
        Attribute id = cc.getIdAttribute();
        for (Attribute a : atts) {
            if (a.equals(id)) continue;
            res.add(AttributeUtils.findValue(a, cc));
        }
    }

    private static Vector<Object> extractColumnNames(CBRCase c) {
        Vector<Object> res = new Vector<Object>();
        res.add("Select");
        DisplayCasesTableWithCritiquesMethod.extractColumnNames(c.getDescription(), res);
        DisplayCasesTableWithCritiquesMethod.extractColumnNames(c.getSolution(), res);
        DisplayCasesTableWithCritiquesMethod.extractColumnNames(c.getJustificationOfSolution(), res);
        DisplayCasesTableWithCritiquesMethod.extractColumnNames(c.getResult(), res);
        return res;
    }

    private static void extractColumnNames(CaseComponent cc, Vector<Object> res) {
        Collection<Attribute> atts = AttributeUtils.getAttributes(cc);
        if (atts == null) {
            return;
        }
        Attribute id = cc.getIdAttribute();
        for (Attribute a : atts) {
            if (a.equals(id)) continue;
            res.add(a.getName());
        }
    }

    private class ItemRadioButtonListener
    implements ActionListener {
        int row = 0;

        public ItemRadioButtonListener(int row) {
            this.row = row;
        }

        public void actionPerformed(ActionEvent arg0) {
            JRadioButton rb = (JRadioButton)arg0.getSource();
            if (rb.isSelected()) {
                DisplayCasesTableWithCritiquesMethod.disableCritiques(this.row);
            }
        }
    }

    private class CritiqueButtonAction
    implements ActionListener {
        CritiqueOption critique;

        public CritiqueButtonAction(CritiqueOption co) {
            this.critique = co;
        }

        public void actionPerformed(ActionEvent arg0) {
            if (table.getSelectedRowCount() <= 0) {
                JOptionPane.showMessageDialog(dialog, "You should choose one item", "Error", 0);
                return;
            }
            Iterator iter = displayedCases.iterator();
            CBRCase _case = (CBRCase)iter.next();
            int i = 0;
            while (i < table.getSelectedRow()) {
                _case = (CBRCase)iter.next();
                ++i;
            }
            critiquedQuery = _case;
            returnCode = -2;
            if (this.critique.getPredicate().getClass().equals(Equal.class)) {
                ObtainQueryWithAttributeQuestionMethod.obtainQueryWithAttributeQuestion(critiquedQuery, this.critique.getAttribute(), new HashMap<Attribute, String>(), _availableCases);
            }
            userCritiques.add(this.critique);
            dialog.setVisible(false);
        }
    }
}

