/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.carrot2;

import java.util.HashMap;
import jcolibri.extensions.textual.carrot2.CarrotClusteringResult;
import jcolibri.extensions.textual.lucene.LuceneDocument;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.carrot2.core.LocalComponent;
import org.carrot2.core.LocalComponentFactory;
import org.carrot2.core.LocalController;
import org.carrot2.core.LocalControllerBase;
import org.carrot2.core.LocalProcess;
import org.carrot2.core.LocalProcessBase;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.impl.ArrayOutputComponent;
import org.carrot2.filter.lingo.local.LingoLocalFilterComponent;
import org.carrot2.input.lucene.LuceneLocalInputComponent;
import org.carrot2.input.lucene.LuceneSearchConfig;

public class CarrotClusterer {
    LocalController controller;
    LuceneIndex index;

    public CarrotClusterer(LuceneIndex index, String[] searchFields) {
        this(index, searchFields, -1);
    }

    public CarrotClusterer(LuceneIndex index, String[] searchFields, int maxclusters) {
        this.index = index;
        try {
            final int _maxclusters = maxclusters;
            this.controller = new LocalControllerBase();
            IndexSearcher searcher = new IndexSearcher(index.getDirectory());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            String urlField = searchFields[0];
            String titleField = LuceneDocument.ID_FIELD;
            String summaryField = searchFields[0];
            final LuceneSearchConfig luceneConfig = new LuceneSearchConfig((Searcher)searcher, (Analyzer)analyzer, searchFields, titleField, summaryField, urlField);
            LocalComponentFactory input = new LocalComponentFactory(){

                public LocalComponent getInstance() {
                    return new LuceneLocalInputComponent(luceneConfig);
                }
            };
            this.controller.addLocalComponentFactory("lucene-myindex", input);
            LocalComponentFactory lingo = new LocalComponentFactory(){

                public LocalComponent getInstance() {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("lsi.threshold.clusterAssignment", "0.01");
                    parameters.put("lsi.threshold.candidateCluster", "3.5");
                    if (_maxclusters > 0) {
                        parameters.put("clusters.num", String.valueOf(_maxclusters));
                    }
                    return new LingoLocalFilterComponent(null, parameters);
                }
            };
            this.controller.addLocalComponentFactory("lingo-classic", lingo);
            LocalComponentFactory output = new LocalComponentFactory(){

                public LocalComponent getInstance() {
                    return new ArrayOutputComponent();
                }
            };
            this.controller.addLocalComponentFactory("buffer", output);
            this.controller.addProcess("lucene-lingo", (LocalProcess)new LocalProcessBase("lucene-myindex", "buffer", new String[]{"lingo-classic"}));
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public CarrotClusteringResult cluster(String query) {
        return this.cluster(query, -1);
    }

    public CarrotClusteringResult cluster(String query, int maxResults) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (maxResults > -1) {
                params.put("requested-results", Integer.toString(maxResults));
            }
            ProgressController.init(this.getClass(), "Carrot2. Clustering documents", -1);
            ProgressController.step(this.getClass());
            ProcessingResult pResult = this.controller.query("lucene-lingo", query, params);
            ArrayOutputComponent.Result result = (ArrayOutputComponent.Result)pResult.getQueryResult();
            ProgressController.finish(this.getClass());
            return new CarrotClusteringResult(result, this.index);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
            return null;
        }
    }
}

