/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local;

import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class EnumDistance
implements LocalSimilarityFunction {
    public double compute(Object o1, Object o2) throws NoApplicableSimilarityFunctionException {
        if (o1 == null || o2 == null) {
            return 0.0;
        }
        if (!(o1 instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), o1.getClass());
        }
        if (!(o2 instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), o2.getClass());
        }
        Enum e1 = (Enum)o1;
        Enum e2 = (Enum)o2;
        double size = e1.getDeclaringClass().getEnumConstants().length;
        double diff = Math.abs(e1.ordinal() - e2.ordinal());
        return 1.0 - diff / size;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Enum;
        }
        if (o2 == null) {
            return o1 instanceof Enum;
        }
        return o1 instanceof Enum && o2 instanceof Enum;
    }
}

