/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders;

import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class McSherryLessIsBetter
implements LocalSimilarityFunction {
    double maxValue;
    double minValue;

    public McSherryLessIsBetter(double maxAttributeValue, double minAttributeValue) {
        this.maxValue = maxAttributeValue;
        this.minValue = minAttributeValue;
    }

    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        double min;
        double max;
        double caseValue;
        if (caseObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof Number) && !(caseObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (caseObject instanceof Number) {
            Number n1 = (Number)caseObject;
            caseValue = n1.doubleValue();
            max = this.maxValue;
            min = this.minValue;
        } else {
            Enum enum1 = (Enum)caseObject;
            caseValue = enum1.ordinal();
            max = caseObject.getClass().getEnumConstants().length;
            min = 0.0;
        }
        return (max - caseValue) / (max - min);
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Number || o2 instanceof Enum;
        }
        if (o2 == null) {
            return o1 instanceof Number || o1 instanceof Enum;
        }
        return o1 instanceof Number && o2 instanceof Number || o1 instanceof Enum && o2 instanceof Enum;
    }
}

