/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.method.gui.formFilling.ObtainQueryWithFormMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryLessOrEqual;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryMoreOrEqual;
import jcolibri.test.recommenders.housesData.HouseDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

public class Houses14
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    Map<Attribute, String> labels;
    ArrayList<Attribute> hiddenAtts;
    FilterConfig filterConfig;

    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.hiddenAtts = new ArrayList();
        this.labels = new HashMap<Attribute, String>();
        this.labels.put(new Attribute("beds", HouseDescription.class), "Min bedrooms");
        this.labels.put(new Attribute("price", HouseDescription.class), "Max price");
        this.labels.put(new Attribute("baths", HouseDescription.class), "Min bahtrooms");
        this.filterConfig = new FilterConfig();
        this.filterConfig.addPredicate(new Attribute("area", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("beds", HouseDescription.class), new QueryLessOrEqual());
        this.filterConfig.addPredicate(new Attribute("price", HouseDescription.class), new QueryMoreOrEqual());
        this.filterConfig.addPredicate(new Attribute("furnished", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("type", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("baths", HouseDescription.class), new QueryLessOrEqual());
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        ObtainQueryWithFormMethod.obtainQueryWithoutInitialValues(query, this.hiddenAtts, this.labels);
        Collection<CBRCase> retrievedCases = FilterBasedRetrievalMethod.filterCases(this._caseBase.getCases(), query, this.filterConfig);
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableBasic(retrievedCases);
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    public void postCycle() throws ExecutionException {
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Houses14 recommender = new Houses14();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            query.setDescription(hd);
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(Houses14.class).error((Object)e);
        }
    }
}

