/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec7;

import java.util.Collection;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.ContentBasedProfile.ObtainQueryFromProfile;
import jcolibri.extensions.textual.IE.common.BasicInformationExtractor;
import jcolibri.extensions.textual.IE.common.DomainTopicClassifier;
import jcolibri.extensions.textual.IE.common.FeaturesExtractor;
import jcolibri.extensions.textual.IE.common.GlossaryLinker;
import jcolibri.extensions.textual.IE.common.PhrasesExtractor;
import jcolibri.extensions.textual.IE.common.StopWordsDetector;
import jcolibri.extensions.textual.IE.common.TextStemmer;
import jcolibri.extensions.textual.IE.common.ThesaurusLinker;
import jcolibri.extensions.textual.IE.opennlp.OpennlpMainNamesExtractor;
import jcolibri.extensions.textual.IE.opennlp.OpennlpPOStagger;
import jcolibri.extensions.textual.IE.opennlp.OpennlpSplitter;
import jcolibri.extensions.textual.wordnet.WordNetBridge;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.OverlapCoefficient;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.recommenders.rec7.RestaurantDescription;
import jcolibri.test.recommenders.rec7.RestaurantsConnector;
import jcolibri.test.test13.gui.ResultFrame;
import jcolibri.test.test13.similarity.AverageMultipleTextValues;
import jcolibri.test.test13.similarity.TokensContained;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

public class Restaurant7
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new RestaurantsConnector("jcolibri/test/test13/restaurants-large-v2.txt");
            this._caseBase = new LinealCaseBase();
            ProgressController.clear();
            SwingProgressBar pb = new SwingProgressBar();
            ProgressController.register(pb);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        ThesaurusLinker.loadWordNet();
        GlossaryLinker.loadGlossary("jcolibri/test/test13/glossary.txt");
        PhrasesExtractor.loadRules("jcolibri/test/test13/phrasesRules.txt");
        FeaturesExtractor.loadRules("jcolibri/test/test13/featuresRules.txt");
        DomainTopicClassifier.loadRules("jcolibri/test/test13/domainRules.txt");
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        OpennlpSplitter.split(cases);
        StopWordsDetector.detectStopWords(cases);
        TextStemmer.stem(cases);
        OpennlpPOStagger.tag(cases);
        OpennlpMainNamesExtractor.extractMainNames(cases);
        PhrasesExtractor.extractPhrases(cases);
        FeaturesExtractor.extractFeatures(cases);
        DomainTopicClassifier.classifyWithTopic(cases);
        BasicInformationExtractor.extractInformation(cases);
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        query = ObtainQueryFromProfile.obtainQueryFromProfile("src/jcolibri/test/recommenders/rec7/profile.xml");
        Collection<CBRCase> cases = this._caseBase.getCases();
        OpennlpSplitter.split(query);
        StopWordsDetector.detectStopWords(query);
        TextStemmer.stem(query);
        OpennlpPOStagger.tag(query);
        OpennlpMainNamesExtractor.extractMainNames(query);
        GlossaryLinker.LinkWithGlossary(cases, query);
        ThesaurusLinker.linkWithWordNet(cases, query);
        PhrasesExtractor.extractPhrases(query);
        FeaturesExtractor.extractFeatures(query);
        DomainTopicClassifier.classifyWithTopic(query);
        BasicInformationExtractor.extractInformation(query);
        NNConfig knnConfig = new NNConfig();
        knnConfig.setDescriptionSimFunction(new Average());
        knnConfig.addMapping(new Attribute("location", RestaurantDescription.class), new Equal());
        knnConfig.addMapping(new Attribute("description", RestaurantDescription.class), new OverlapCoefficient());
        knnConfig.addMapping(new Attribute("price", RestaurantDescription.class), new AverageMultipleTextValues(1000.0));
        knnConfig.addMapping(new Attribute("foodType", RestaurantDescription.class), new TokensContained());
        knnConfig.addMapping(new Attribute("food", RestaurantDescription.class), new TokensContained());
        knnConfig.addMapping(new Attribute("alcohol", RestaurantDescription.class), new Equal());
        knnConfig.addMapping(new Attribute("takeout", RestaurantDescription.class), new Equal());
        knnConfig.addMapping(new Attribute("delivery", RestaurantDescription.class), new Equal());
        knnConfig.addMapping(new Attribute("parking", RestaurantDescription.class), new Equal());
        knnConfig.addMapping(new Attribute("catering", RestaurantDescription.class), new Equal());
        System.out.println("RESULT:");
        Collection<RetrievalResult> res = NNScoringMethod.evaluateSimilarity(cases, query, knnConfig);
        res = SelectCases.selectTopKRR(res, 5);
        for (RetrievalResult rr : res) {
            System.out.println(rr);
        }
        RestaurantDescription qrd = (RestaurantDescription)query.getDescription();
        CBRCase mostSimilar = res.iterator().next().get_case();
        RestaurantDescription rrd = (RestaurantDescription)mostSimilar.getDescription();
        new ResultFrame(qrd.getDescription().toString(), rrd.getName(), rrd.getAddress(), rrd.getDescription().toString());
    }

    public void postCycle() throws ExecutionException {
        WordNetBridge.deInit();
        this._connector.close();
    }

    public static void main(String[] args) {
        Restaurant7 test = new Restaurant7();
        try {
            test.configure();
            CBRCaseBase caseBase = test.preCycle();
            System.out.println("CASE BASE: ");
            for (CBRCase c : caseBase.getCases()) {
                System.out.println(c);
            }
            System.out.println("Total: " + caseBase.getCases().size() + " cases");
            test.cycle(null);
            test.postCycle();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(Restaurant7.class).error((Object)e);
        }
    }
}

