/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test11;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.util.ArrayList;
import jcolibri.datatypes.Instance;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntCosine;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDeep;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDeepBasic;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDetail;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;
import org.apache.commons.logging.LogFactory;

public class Test11 {
    public static void main(String[] args) {
        try {
            OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
            ob.initWithPelletReasoner();
            OntologyDocument mainOnto = new OntologyDocument("http://gaia.fdi.ucm.es/ontologies/personalTrainer.owl", FileIO.findFile("jcolibri/test/test11/personalTrainer.owl").toExternalForm());
            ArrayList subOntologies = new ArrayList();
            ob.loadOntology(mainOnto, subOntologies, false);
            OntCosine cosine = new OntCosine();
            OntDeepBasic deepbasic = new OntDeepBasic();
            OntDeep deep = new OntDeep();
            OntDetail detail = new OntDetail();
            Instance biceps = new Instance("biceps");
            Instance triceps = new Instance("triceps");
            Instance pectoralis = new Instance("pectoralis");
            Instance abdominis = new Instance("abdominis");
            Instance quadriceps = new Instance("quadriceps");
            Instance deltoid = new Instance("deltoid");
            System.out.println(ob.LCS("pectoralis", "deltoid"));
            System.out.format("\n\t\t\t\tDeepBasic\tDeep\t\tCosine\t\tDetail\nsim(biceps, triceps)\t\t%.3f\t\t%.3f\t\t%.3f\t\t%.3f\n", deepbasic.compute(biceps, triceps), deep.compute(biceps, triceps), cosine.compute(biceps, triceps), detail.compute(biceps, triceps));
            System.out.format("sim(pectoralis, abdominis)\t%.3f\t\t%.3f\t\t%.3f\t\t%.3f\n", deepbasic.compute(pectoralis, abdominis), deep.compute(pectoralis, abdominis), cosine.compute(pectoralis, abdominis), detail.compute(pectoralis, abdominis));
            System.out.format("sim(triceps, abdominis)\t\t%.3f\t\t%.3f\t\t%.3f\t\t%.3f\n", deepbasic.compute(triceps, abdominis), deep.compute(triceps, abdominis), cosine.compute(triceps, abdominis), detail.compute(triceps, abdominis));
            System.out.format("sim(triceps, cuadriceps)\t%.3f\t\t%.3f\t\t%.3f\t\t%.3f\n", deepbasic.compute(triceps, quadriceps), deep.compute(triceps, quadriceps), cosine.compute(triceps, quadriceps), detail.compute(triceps, quadriceps));
            System.out.format("sim(pectoralis, deltoid)\t%.3f\t\t%.3f\t\t%.3f\t\t%.3f\n", deepbasic.compute(pectoralis, deltoid), deep.compute(pectoralis, deltoid), cosine.compute(pectoralis, deltoid), detail.compute(pectoralis, deltoid));
        }
        catch (Exception e) {
            LogFactory.getLog(OntDeepBasic.class).error((Object)e);
        }
    }
}

