/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test15;

import jcolibri.cbrcore.Attribute;
import jcolibri.evaluation.Evaluator;
import jcolibri.evaluation.evaluators.SameSplitEvaluator;
import jcolibri.extensions.maintenance_evaluation.DetailedEvaluationReport;
import jcolibri.extensions.maintenance_evaluation.evaluators.MaintenanceSameSplitEvaluator;
import jcolibri.method.maintenance.algorithms.BBNRNoiseReduction;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.SimilarityWeightedVotingMethod;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.test15.IrisDescription;
import jcolibri.test.test15.IrisEvaluableApp;
import jcolibri.test.test15.IrisMaintainedEvaluableApp;
import jcolibri.util.ProgressController;

public class Test15 {
    public static void main(String[] args) {
        KNNClassificationConfig irisSimConfig = new KNNClassificationConfig();
        irisSimConfig.setDescriptionSimFunction(new Average());
        irisSimConfig.addMapping(new Attribute("sepalLength", IrisDescription.class), new Interval(3.6));
        irisSimConfig.addMapping(new Attribute("sepalWidth", IrisDescription.class), new Interval(2.4));
        irisSimConfig.addMapping(new Attribute("petalLength", IrisDescription.class), new Interval(5.9));
        irisSimConfig.addMapping(new Attribute("petalWidth", IrisDescription.class), new Interval(2.4));
        irisSimConfig.setClassificationMethod(new SimilarityWeightedVotingMethod());
        irisSimConfig.setK(3);
        ProgressController.clear();
        ProgressController.register(new SwingProgressBar(), MaintenanceSameSplitEvaluator.class);
        int splitPercent = 30;
        SameSplitEvaluator split = new SameSplitEvaluator();
        split.init(new IrisEvaluableApp());
        split.generateSplit(splitPercent, "split.txt");
        MaintenanceSameSplitEvaluator eval = new MaintenanceSameSplitEvaluator();
        eval.init(new IrisEvaluableApp());
        eval.HoldOutfromFile("split.txt");
        Double avgCost = ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).getAverageOfQueryDataSeries("Iris Prediction Cost");
        Double percentAccuracy = (1.0 - avgCost) * 100.0;
        Evaluator.getEvaluationReport().putOtherData("Iris Prediction Cost Accuracy", percentAccuracy + "%");
        eval = new MaintenanceSameSplitEvaluator();
        eval.init(new IrisMaintainedEvaluableApp(irisSimConfig), new BBNRNoiseReduction(), irisSimConfig);
        eval.HoldOutfromFile("split.txt");
        avgCost = ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).getAverageOfQueryDataSeries("RENN Iris Prediction Cost");
        percentAccuracy = (1.0 - avgCost) * 100.0;
        Evaluator.getEvaluationReport().putOtherData("RENN Iris Prediction Cost Accuracy", percentAccuracy + "%");
        double avgPercentReduced = ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).getAverageOfDataSeries("Percent reduced");
        Evaluator.getEvaluationReport().putOtherData("RENN Iris Prediction Cost CB Reduction", avgPercentReduced + "%");
        ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).removeDataSeries("Percent reduced");
        System.out.println(Evaluator.getEvaluationReport());
        ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).printDetailedEvaluationReport("results.txt");
    }
}

