/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test3;

import java.util.Collection;
import java.util.HashMap;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.DataBaseConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.CombineQueryAndCasesMethod;
import jcolibri.method.revise.DefineNewIdsMethod;
import jcolibri.test.database.HSQLDBserver;
import jcolibri.test.test3.Region;
import jcolibri.test.test3.TravelDescription;
import jcolibri.util.FileIO;

public class Test3
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new DataBaseConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test3/databaseconfig.xml"));
            this._caseBase = new LinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        for (CBRCase c : this._caseBase.getCases()) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        NNConfig simConfig = new NNConfig();
        simConfig.setDescriptionSimFunction(new Average());
        simConfig.addMapping(new Attribute("Accommodation", TravelDescription.class), new Equal());
        Attribute duration = new Attribute("Duration", TravelDescription.class);
        simConfig.addMapping(duration, new Interval(31.0));
        simConfig.setWeight(duration, 0.5);
        simConfig.addMapping(new Attribute("HolidayType", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("NumberOfPersons", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("Price", TravelDescription.class), new Interval(4000.0));
        simConfig.addMapping(new Attribute("Region", TravelDescription.class), new Average());
        simConfig.addMapping(new Attribute("region", Region.class), new Equal());
        simConfig.addMapping(new Attribute("city", Region.class), new Equal());
        simConfig.addMapping(new Attribute("airport", Region.class), new Equal());
        simConfig.addMapping(new Attribute("currency", Region.class), new Equal());
        System.out.println("Query:");
        System.out.println(query);
        System.out.println();
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this._caseBase.getCases(), query, simConfig);
        Collection<CBRCase> selectedcases = SelectCases.selectTopK(eval, 1);
        Collection<CBRCase> newcases = CombineQueryAndCasesMethod.combine(query, selectedcases);
        System.out.println("Combined cases");
        for (CBRCase c : newcases) {
            System.out.println(c);
        }
        CBRCase bestCase = newcases.iterator().next();
        HashMap<Attribute, Object> componentsKeys = new HashMap<Attribute, Object>();
        componentsKeys.put(new Attribute("caseId", TravelDescription.class), "test3id");
        componentsKeys.put(new Attribute("id", Region.class), 7);
        DefineNewIdsMethod.defineNewIdsMethod(bestCase, componentsKeys);
        System.out.println("Cases with new Id");
        System.out.println(bestCase);
    }

    public void postCycle() throws ExecutionException {
        this._caseBase.close();
    }

    public static void main(String[] args) {
        HSQLDBserver.init();
        Test3 test3 = new Test3();
        try {
            test3.configure();
            test3.preCycle();
            TravelDescription queryDesc = new TravelDescription();
            queryDesc.setAccommodation(TravelDescription.AccommodationTypes.ThreeStars);
            queryDesc.setDuration(7);
            queryDesc.setHolidayType("Recreation");
            queryDesc.setNumberOfPersons(2);
            queryDesc.setPrice(700);
            Region region = new Region();
            region.setRegion("Bulgaria");
            region.setCity("Sofia");
            region.setCurrency("Euro");
            region.setAirport("airport");
            queryDesc.setRegion(region);
            CBRQuery query = new CBRQuery();
            query.setDescription(queryDesc);
            test3.cycle(query);
            test3.postCycle();
            HSQLDBserver.shutDown();
        }
        catch (ExecutionException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

