/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test8;

import java.util.Collection;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.DataBaseConnector;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.test.test8.TravelDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvaluableApp
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    private Log log;

    public void configure() throws ExecutionException {
        try {
            this._connector = new DataBaseConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test8/databaseconfig.xml"));
            this._caseBase = new CachedLinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        this.log = LogFactory.getLog(this.getClass());
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        NNConfig simConfig = new NNConfig();
        simConfig.setDescriptionSimFunction(new Average());
        simConfig.addMapping(new Attribute("Accomodation", TravelDescription.class), new Equal());
        Attribute duration = new Attribute("Duration", TravelDescription.class);
        simConfig.addMapping(duration, new Interval(31.0));
        simConfig.setWeight(duration, 0.5);
        simConfig.addMapping(new Attribute("HolidayType", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("NumberOfPersons", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("Price", TravelDescription.class), new Interval(4000.0));
        this.log.info((Object)("Query: " + query.getDescription()));
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this._caseBase.getCases(), query, simConfig);
        Evaluator.getEvaluationReport().addDataToSeries("Similarity", new Double(eval.iterator().next().getEval()));
    }

    public void postCycle() throws ExecutionException {
        this._caseBase.close();
    }
}

