/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.connector.TypeAdaptor;
import jcolibri.exception.AttributeAccessException;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUtils {
    public static Attribute[] getAttributes(Class c) {
        Field[] fields = c.getDeclaredFields();
        Attribute[] res = new Attribute[fields.length];
        int i = 0;
        Field[] fieldArray = fields;
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            res[i++] = new Attribute(f);
            ++n;
        }
        return res;
    }

    public static Collection<Attribute> getAttributes(CaseComponent cc) {
        if (cc == null) {
            return null;
        }
        ArrayList<Attribute> res = new ArrayList<Attribute>();
        try {
            Attribute[] ats;
            Attribute[] attributeArray = ats = AttributeUtils.getAttributes(cc.getClass());
            int n = 0;
            int n2 = attributeArray.length;
            while (n < n2) {
                Attribute a = attributeArray[n];
                if (a.getType().equals(CaseComponent.class)) {
                    res.addAll(AttributeUtils.getAttributes((CaseComponent)a.getValue(cc)));
                } else {
                    res.add(a);
                }
                ++n;
            }
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(AttributeUtils.class).error((Object)e);
        }
        return res;
    }

    public static Collection<Attribute> getAttributes(CaseComponent cc, Class _class) {
        if (cc == null) {
            return null;
        }
        ArrayList<Attribute> res = new ArrayList<Attribute>();
        try {
            Attribute[] ats;
            Attribute[] attributeArray = ats = AttributeUtils.getAttributes(cc.getClass());
            int n = 0;
            int n2 = attributeArray.length;
            while (n < n2) {
                Attribute a = attributeArray[n];
                if (a.getType().equals(CaseComponent.class)) {
                    res.addAll(AttributeUtils.getAttributes((CaseComponent)a.getValue(cc)));
                } else if (_class.isInstance(a.getValue(cc))) {
                    res.add(a);
                }
                ++n;
            }
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(AttributeUtils.class).error((Object)e);
        }
        return res;
    }

    public static CaseComponent findBelongingComponent(Attribute at, CaseComponent cc) {
        try {
            Attribute[] atts;
            if (at.getDeclaringClass().equals(cc.getClass())) {
                return cc;
            }
            Attribute[] attributeArray = atts = AttributeUtils.getAttributes(cc.getClass());
            int n = 0;
            int n2 = attributeArray.length;
            while (n < n2) {
                CaseComponent r;
                Attribute a = attributeArray[n];
                Object o = a.getValue(cc);
                if (o != null && o instanceof CaseComponent && (r = AttributeUtils.findBelongingComponent(at, (CaseComponent)o)) != null) {
                    return r;
                }
                ++n;
            }
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(AttributeUtils.class).error((Object)e);
        }
        return null;
    }

    public static CaseComponent findBelongingComponent(Attribute at, CBRQuery q) {
        return AttributeUtils.findBelongingComponent(at, q.getDescription());
    }

    public static CaseComponent findBelongingComponent(Attribute at, CBRCase c) {
        CaseComponent res = AttributeUtils.findBelongingComponent(at, c.getDescription());
        if (res != null) {
            return res;
        }
        res = AttributeUtils.findBelongingComponent(at, c.getSolution());
        if (res != null) {
            return res;
        }
        res = AttributeUtils.findBelongingComponent(at, c.getJustificationOfSolution());
        if (res != null) {
            return res;
        }
        res = AttributeUtils.findBelongingComponent(at, c.getResult());
        if (res != null) {
            return res;
        }
        return null;
    }

    public static Object findValue(Attribute at, CaseComponent cc) {
        CaseComponent belongCC = AttributeUtils.findBelongingComponent(at, cc);
        if (belongCC == null) {
            return null;
        }
        try {
            return at.getValue(cc);
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(AttributeUtils.class).error((Object)e);
            return null;
        }
    }

    public static Object findValue(Attribute at, CBRQuery query) {
        return AttributeUtils.findValue(at, query.getDescription());
    }

    public static Object findValue(Attribute at, CBRCase c) {
        CaseComponent cc = AttributeUtils.findBelongingComponent(at, c);
        if (cc == null) {
            return null;
        }
        return AttributeUtils.findValue(at, cc);
    }

    public static void setValue(Attribute at, CaseComponent cc, Object value) {
        CaseComponent belongCC = AttributeUtils.findBelongingComponent(at, cc);
        if (belongCC == null) {
            return;
        }
        try {
            at.setValue(cc, value);
        }
        catch (AttributeAccessException e) {
            try {
                if (TypeAdaptor.class.isAssignableFrom(at.getType())) {
                    String content = value.toString();
                    TypeAdaptor ta = (TypeAdaptor)at.getType().newInstance();
                    ta.fromString(content);
                    at.setValue(cc, at.getType().cast(ta));
                }
            }
            catch (Exception e2) {
                LogFactory.getLog(AttributeUtils.class).error((Object)e2);
            }
        }
    }

    public static void setValue(Attribute at, CBRQuery query, Object value) {
        AttributeUtils.setValue(at, query.getDescription(), value);
    }

    public static void setValue(Attribute at, CBRCase c, Object value) {
        CaseComponent cc = AttributeUtils.findBelongingComponent(at, c);
        if (cc == null) {
            return;
        }
        AttributeUtils.setValue(at, cc, value);
    }
}

