/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import jcolibri.util.ProgressListener;

public class ProgressController {
    public static final int UNKNOWN_STEPS = -1;
    static Hashtable<Class, Collection<ProgressListener>> listeners = new Hashtable();
    static Collection<ProgressListener> listenersEverything = new ArrayList<ProgressListener>();

    public static void clear() {
        listeners.clear();
        listenersEverything.clear();
    }

    public static void register(ProgressListener pl, Class c) {
        Collection<ProgressListener> l = listeners.get(c);
        if (l == null) {
            l = new ArrayList<ProgressListener>();
            listeners.put(c, l);
        }
        l.add(pl);
    }

    public static void register(ProgressListener pl) {
        listenersEverything.add(pl);
    }

    public static void deregister(ProgressListener pl, Class c) {
        Collection<ProgressListener> l = listeners.get(c);
        if (l != null) {
            l.remove(pl);
        }
    }

    public static void deregister(ProgressListener pl) {
        listenersEverything.remove(pl);
    }

    public static void init(Class c, String info, int numberOfSteps) {
        Collection<ProgressListener> ls = listeners.get(c);
        if (ls != null) {
            for (ProgressListener pl : ls) {
                pl.init(info, numberOfSteps);
            }
        }
        for (ProgressListener pl : listenersEverything) {
            pl.init(info, numberOfSteps);
        }
    }

    public static void step(Class c) {
        Collection<ProgressListener> ls = listeners.get(c);
        if (ls != null) {
            for (ProgressListener pl : ls) {
                pl.step();
            }
        }
        for (ProgressListener pl : listenersEverything) {
            pl.step();
        }
    }

    public static void finish(Class c) {
        Collection<ProgressListener> ls = listeners.get(c);
        if (ls != null) {
            for (ProgressListener pl : ls) {
                pl.finish();
            }
        }
        for (ProgressListener pl : listenersEverything) {
            pl.finish();
        }
    }
}

