import net.sourceforge.jFuzzyLogic.FIS;
import net.sourceforge.jFuzzyLogic.FunctionBlock;
import net.sourceforge.jFuzzyLogic.plot.JFuzzyChart;
import net.sourceforge.jFuzzyLogic.rule.Variable;

import java.util.ArrayList;
import java.util.List;



public class DiswasherRecipe {


		public void Fuzzy(Request request) throws Exception {
			

			List<Recipe> myList = new ArrayList<Recipe>(9);


			//Variable a=new Variable(null);
			//a.add(null);
			
			String filename = "prewashing.fcl";
			String filename1 = "washing.fcl";
			String filename2 = "rinsing.fcl";
			String filename3 = "drying.fcl";
			
			FIS fis = FIS.load(filename, true);
			if (fis == null) {
				System.err.println("Can't load file: '" + filename + "'");
				System.exit(1);
			}
			
			FIS fis1 = FIS.load(filename1, true);
			if (fis1 == null) {
				System.err.println("Can't load file: '" + filename1 + "'");
				System.exit(1);
			}
			
			FIS fis2 = FIS.load(filename2, true);
			if (fis2 == null) {
				System.err.println("Can't load file: '" + filename2 + "'");
				System.exit(1);
			}
			
			FIS fis3 = FIS.load(filename3, true);
			if (fis3 == null) {
				System.err.println("Can't load file: '" + filename3 + "'");
				System.exit(1);
			}
			// Get default function block
			FunctionBlock fb = fis.getFunctionBlock(null);
			FunctionBlock fb1 = fis1.getFunctionBlock(null);
			FunctionBlock fb2 = fis2.getFunctionBlock(null);
			FunctionBlock fb3 = fis3.getFunctionBlock(null);
			
			// Set inputs
			fb.setVariable("load", request.Load);
			fb.setVariable("type_load", request.Type_Load);
			fb.setVariable("dirtyness", request.Dirtyness);
			
			fb1.setVariable("load", request.Load);
			fb1.setVariable("type_load", request.Type_Load);
			fb1.setVariable("dirtyness", request.Dirtyness);
			
			fb2.setVariable("load", request.Load);
			fb2.setVariable("type_load", request.Type_Load);
			fb2.setVariable("dirtyness", request.Dirtyness);
			
			fb3.setVariable("load", request.Load);
			fb3.setVariable("type_load", request.Type_Load);
			
			//Show input sets
			JFuzzyChart.get().chart(fb);
			//JFuzzyChart.get().chart(fb1);
			//JFuzzyChart.get().chart(fb2);
			//JFuzzyChart.get().chart(fb3);
			
			// Evaluate
			fb.evaluate();
			fb1.evaluate();
			fb2.evaluate();
			fb3.evaluate();

			// Show output variable's chart
			//fb.getVariable("time").defuzzify(); //Return the defuzzified value
			//fb.getVariable("water").defuzzify();
			//fb.getVariable("temperature").defuzzify();
			//fb1.getVariable("time").defuzzify();
			//fb1.getVariable("water").defuzzify();
			//fb1.getVariable("temperature").defuzzify();
			//fb2.getVariable("time").defuzzify();
			//fb2.getVariable("water").defuzzify();
			//fb2.getVariable("temperature").defuzzify();
			//fb3.getVariable("time").defuzzify();

			// Prewashing values
			System.out.println("*************Recipe Parameters**************");
			System.out.println("Prewashing");
			double prewashing_time=fb.getVariable("time").getValue();
			if(prewashing_time<1)
				prewashing_time=0;
			Recipe st1=new Recipe();
			st1.Parameter="time";
			st1.Value=prewashing_time;
			myList.add(st1);
			System.out.println("Time: " + prewashing_time);
			double prewashing_water=fb.getVariable("water").getValue();
			if(prewashing_water<1)
				prewashing_water=0;
			Recipe st2=new Recipe();
			st2.Parameter="water";
			st2.Value=prewashing_water;
			myList.add(st2);
			System.out.println("Water: " + prewashing_water);
			double prewashing_temperature=fb.getVariable("temperature").getValue();
			if(prewashing_temperature<1)
				prewashing_temperature=0;
			Recipe st3=new Recipe();
			st3.Parameter="temperature";
			st3.Value=prewashing_temperature;
			myList.add(st3);
			System.out.println("Temperature: " + prewashing_temperature);
			
			// Washing values
			System.out.println("Washing");
			double washing_time=fb1.getVariable("time").getValue();
			if(washing_time<1)
				washing_time=0;
			Recipe st4=new Recipe();
			st1.Parameter="time";
			st1.Value=washing_time;
			myList.add(st4);
			System.out.println("Time: " + washing_time);
			double washing_water=fb1.getVariable("water").getValue();
			if(washing_water<1)
				washing_water=0;
			Recipe st5=new Recipe();
			st5.Parameter="water";
			st5.Value=washing_water;
			myList.add(st5);
			System.out.println("Water: " + washing_water);
			double washing_temperature=fb1.getVariable("temperature").getValue();
			if(washing_temperature<1)
				washing_temperature=0;
			Recipe st6=new Recipe();
			st6.Parameter="temperature";
			st6.Value=washing_temperature;
			myList.add(st6);
			System.out.println("Temperature: " + washing_temperature);
			
			// Rinsinging values
			System.out.println("Rinsing");
			double rinsing_time=fb1.getVariable("time").getValue();
			if(rinsing_time<1)
				rinsing_time=0;
			Recipe st7=new Recipe();
			st7.Parameter="time";
			st7.Value=rinsing_time;
			myList.add(st7);
			System.out.println("Time: " + rinsing_time);
			double rinsing_water=fb1.getVariable("water").getValue();
			if(rinsing_water<1)
				rinsing_water=0;
			Recipe st8=new Recipe();
			st8.Parameter="water";
			st8.Value=rinsing_water;
			myList.add(st8);
			System.out.println("Water: " + rinsing_water);
			double rinsing_temperature=fb2.getVariable("temperature").getValue();
			if(rinsing_temperature<1)
				rinsing_temperature=0;
			Recipe st9=new Recipe();
			st9.Parameter="temperature";
			st9.Value=rinsing_temperature;
			myList.add(st9);
			System.out.println("Temperature: " + rinsing_temperature);
			
			// Drying values
			System.out.println("Drying");
			double drying_time=fb3.getVariable("time").getValue();
			if(drying_time<1)
				drying_time=0;
			Recipe st10=new Recipe();
			st10.Parameter="time";
			st10.Value=drying_time;
			myList.add(st10);
			System.out.println("Time: " + drying_time);
			System.out.println("********************************************");
			
			//Print output Result
			Variable time = fb3.getVariable("time");
	        JFuzzyChart.get().chart(time, time.getDefuzzifier(), true);
			
			WriteDishwasherRecipe dis=new WriteDishwasherRecipe();

			dis.WriteXML(myList);

		}

}

