/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTester
extends JFrame {
    private static final long serialVersionUID = 1L;
    JList list;
    List<ExampleInfo> info;
    JTabbedPane tabPane;
    JTextArea displayPane;
    JButton run;
    JDialog mapDialog;

    public MainTester(String configfile) {
        this.info = this.parseExampleInfo(configfile);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSize(new Dimension(800, 600));
        this.setTitle("jCOLIBRI2 Tester");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
        JPanel panelUp = new JPanel();
        panelUp.setBorder(BorderFactory.createTitledBorder("Available Tests"));
        JPanel panelDown = new JPanel();
        panelDown.setBorder(BorderFactory.createTitledBorder("Execution log"));
        JSplitPane split = new JSplitPane(0, panelUp, panelDown);
        split.setDividerLocation(400);
        this.getContentPane().add(split);
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BorderLayout());
        Object[] data = new Object[this.info.size()];
        int i = 0;
        for (ExampleInfo ei : this.info) {
            data[i++] = ei.getName();
        }
        this.list = new JList<Object>(data);
        this.list.setSelectionMode(1);
        this.list.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.list);
        topLeft.add((Component)listScroller, "Center");
        this.run = new JButton("Execute");
        this.run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainTester.this.runExample();
            }
        });
        this.mapDialog = new JDialog((Frame)this, true);
        this.mapDialog.getContentPane().add(new HTMLBrowser(FileIO.findFile("jcolibri/test/main/map.html")));
        this.mapDialog.setSize(new Dimension(800, 600));
        this.mapDialog.setTitle("jCOLIBRI2 Examples Map");
        this.mapDialog.setBounds((screenSize.width - this.mapDialog.getWidth()) / 2, (screenSize.height - this.mapDialog.getHeight()) / 2, this.mapDialog.getWidth(), this.mapDialog.getHeight());
        JButton map = new JButton("Map");
        map.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainTester.this.mapDialog.setVisible(true);
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BorderLayout(2, 1));
        buttonsPanel.add((Component)this.run, "Center");
        buttonsPanel.add((Component)map, "East");
        topLeft.add((Component)buttonsPanel, "South");
        panelUp.setLayout(new BorderLayout());
        panelUp.add((Component)topLeft, "West");
        this.tabPane = new JTabbedPane();
        panelUp.add((Component)this.tabPane, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (MainTester.this.list.getSelectedIndex() == -1) {
                    return;
                }
                int i = MainTester.this.list.getSelectedIndex();
                MainTester.this.setExample(i);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.displayPane = new JTextArea();
        this.displayPane.setEditable(false);
        panelDown.setLayout(new BorderLayout());
        panelDown.add(new JScrollPane(this.displayPane));
        PrintStream aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
        System.setOut(aPrintStream);
        System.setErr(aPrintStream);
        ConsoleAppender a = (ConsoleAppender)Logger.getRootLogger().getAllAppenders().nextElement();
        Layout l = a.getLayout();
        Logger.getRootLogger().addAppender((Appender)new WriterAppender(l, (OutputStream)aPrintStream));
        Logger.getRootLogger().removeAppender((Appender)a);
    }

    public void runExample() {
        this.run.setEnabled(false);
        try {
            Method[] methods;
            int i = this.list.getSelectedIndex();
            if (i == -1) {
                return;
            }
            this.displayPane.setText("");
            ExampleInfo ei = this.info.get(i);
            MethodRunner mr = null;
            Class c = ei.getMainClass();
            Method[] methodArray = methods = c.getMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method m = methodArray[n];
                if (m.getName().equals("main")) {
                    mr = new MethodRunner(m);
                }
                ++n;
            }
            if (mr == null) {
                return;
            }
            Thread executionThread = new Thread(mr);
            executionThread.start();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void setExample(int i) {
        try {
            ExampleInfo ei = this.info.get(i);
            this.tabPane.removeAll();
            JEditorPane ep = new JEditorPane();
            ep.setContentType("text/html");
            ep.setText("<font face=\"verdana, arial, helvetica\"><b>" + ei.getDescription() + "</b></font>");
            ep.setEditable(false);
            this.tabPane.add("Description", new JScrollPane(ep));
            ep = new JEditorPane(ei.getSource());
            ep.setContentType("text/html");
            ep.setEditable(false);
            this.tabPane.add("Source", new JScrollPane(ep));
            for (URL url : ei.getDoc()) {
                int b = url.getFile().lastIndexOf(47) + 1;
                int e = url.getFile().lastIndexOf(".html");
                String name = url.getFile().substring(b, e);
                if (name.equals("package-summary")) {
                    String aux = url.getFile().substring(0, b - 1);
                    int x = aux.lastIndexOf(47) + 1;
                    name = aux.substring(x);
                }
                this.tabPane.add("[Doc]" + name, new HTMLBrowser(url));
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public static void main(String[] args) {
        MainTester main = new MainTester("jcolibri/test/main/examples.config");
        main.setVisible(true);
        MainTester mainTester = main;
        mainTester.getClass();
        mainTester.new LogoFrame(FileIO.findFile("/jcolibri/test/main/jcolibri2.jpg"), 2000L);
    }

    public List<ExampleInfo> parseExampleInfo(String file) {
        ArrayList<ExampleInfo> info = new ArrayList<ExampleInfo>();
        try {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(FileIO.findFile(file).openStream()));
            if (br == null) {
                throw new Exception("Error opening file: " + file);
            }
            String line = "";
            while ((line = br.readLine()) != null) {
                ExampleInfo ei = new ExampleInfo();
                ei.setName(line);
                ei.setDescription(br.readLine());
                ei.setMainClass(Class.forName(br.readLine()));
                ei.setSource(FileIO.findFile(br.readLine()));
                while (!(line = br.readLine()).equals("<example>")) {
                    ei.addDoc(FileIO.findFile(line));
                }
                info.add(ei);
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
        return info;
    }

    class MethodRunner
    implements Runnable {
        Method method;

        MethodRunner(Method m) {
            this.method = m;
        }

        public void run() {
            Object[] args = new Object[]{null};
            try {
                this.method.invoke(null, args);
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
                e.printStackTrace();
            }
            LogFactory.getLog(MainTester.class).info((Object)"Test execution finished");
            MainTester.this.run.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExampleInfo {
        String name;
        String description;
        Collection<URL> doc;
        URL source;
        Class mainClass;

        public ExampleInfo() {
            this.doc = new ArrayList<URL>();
        }

        public ExampleInfo(String name, String description, Collection<URL> doc) {
            this.name = name;
            this.description = description;
            this.doc = doc;
        }

        public Class getMainClass() {
            return this.mainClass;
        }

        public void setMainClass(Class mainClass) {
            this.mainClass = mainClass;
        }

        public URL getSource() {
            return this.source;
        }

        public void setSource(URL source) {
            this.source = source;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Collection<URL> getDoc() {
            return this.doc;
        }

        public void setDoc(Collection<URL> doc) {
            this.doc = doc;
        }

        public void addDoc(URL url) {
            this.doc.add(url);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    class HTMLBrowser
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JEditorPane doc;
        URL originalURL;

        public HTMLBrowser(URL file) {
            this.originalURL = file;
            JPanel top = new JPanel();
            top.setLayout(new BoxLayout(top, 0));
            JButton prev = new JButton("Back");
            prev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        HTMLBrowser.this.doc.setPage(HTMLBrowser.this.originalURL);
                    }
                    catch (IOException e1) {
                        LogFactory.getLog(this.getClass()).error((Object)e1);
                    }
                }
            });
            JLabel urlInfo = new JLabel(file.toString());
            top.add(prev);
            top.add(Box.createHorizontalGlue());
            top.add(urlInfo);
            this.doc = new JEditorPane();
            this.doc.setContentType("text/html");
            this.doc.setEditable(false);
            this.doc.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    try {
                        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            HTMLBrowser.this.doc.setPage(e.getURL());
                        }
                    }
                    catch (IOException e1) {
                        LogFactory.getLog(this.getClass()).error((Object)e1);
                    }
                }
            });
            try {
                this.doc.setPage(file);
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)top, "North");
            this.add((Component)new JScrollPane(this.doc), "Center");
        }
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            MainTester.this.displayPane.append(aString);
            MainTester.this.displayPane.setCaretPosition(MainTester.this.displayPane.getDocument().getLength());
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            MainTester.this.displayPane.append(aString);
            MainTester.this.displayPane.setCaretPosition(MainTester.this.displayPane.getDocument().getLength());
        }
    }

    public class LogoFrame
    extends JWindow
    implements Runnable {
        private static final long serialVersionUID = 1L;
        long time;

        public LogoFrame(URL image, long time) throws HeadlessException {
            try {
                this.time = time;
                JLabel jLabel1 = new JLabel();
                jLabel1.setIcon(new ImageIcon(image));
                jLabel1.setBorder(BorderFactory.createRaisedBevelBorder());
                this.getContentPane().add((Component)jLabel1, "Center");
                this.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
                this.setVisible(true);
                Thread thread = new Thread(this);
                thread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            this.dispose();
        }
    }
}

