/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JFrame;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.converters.ArffSaver;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.gui.Logger;
import weka.gui.beans.AbstractDataSink;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSink;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.WekaWrapper;

public class Saver
extends AbstractDataSink
implements WekaWrapper,
EnvironmentHandler {
    private static final long serialVersionUID = 5371716690308950755L;
    private Instances m_dataSet;
    private Instances m_structure;
    protected String m_globalInfo;
    private transient SaveBatchThread m_ioThread;
    private weka.core.converters.Saver m_Saver;
    private weka.core.converters.Saver m_SaverTemplate;
    private String m_fileName;
    private boolean m_isDBSaver;
    private boolean m_relationNameForFilename;
    private int m_count;
    protected transient Environment m_env;

    private weka.core.converters.Saver makeCopy() throws Exception {
        return (weka.core.converters.Saver)new SerializedObject(this.m_SaverTemplate).getObject();
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_ioThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public boolean isBusy() {
        return this.m_ioThread != null;
    }

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Saver() {
        this.m_SaverTemplate = this.m_Saver = new ArffSaver();
        this.m_relationNameForFilename = true;
        this.setSaverTemplate(this.m_Saver);
        this.m_fileName = "";
        this.m_dataSet = null;
        this.m_count = 0;
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    private void passEnvOnToSaver() {
        if (this.m_SaverTemplate instanceof EnvironmentHandler && this.m_env != null) {
            ((EnvironmentHandler)((Object)this.m_Saver)).setEnvironment(this.m_env);
        }
    }

    public void setSaverTemplate(weka.core.converters.Saver saver) {
        boolean loadImages = true;
        if (saver.getClass().getName().compareTo(this.m_SaverTemplate.getClass().getName()) == 0) {
            loadImages = false;
        }
        this.m_SaverTemplate = saver;
        String saverName = saver.getClass().toString();
        saverName = saverName.substring(saverName.lastIndexOf(46) + 1, saverName.length());
        if (loadImages && !this.m_visual.loadIcons("weka/gui/beans/icons/" + saverName + ".gif", "weka/gui/beans/icons/" + saverName + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(saverName);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_SaverTemplate);
        this.m_isDBSaver = this.m_SaverTemplate instanceof DatabaseConverter;
    }

    protected String sanitizeFilename(String filename) {
        filename = filename.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
        filename = Utils.removeSubstring(filename, "weka.filters.supervised.instance.");
        filename = Utils.removeSubstring(filename, "weka.filters.supervised.attribute.");
        filename = Utils.removeSubstring(filename, "weka.filters.unsupervised.instance.");
        filename = Utils.removeSubstring(filename, "weka.filters.unsupervised.attribute.");
        filename = Utils.removeSubstring(filename, "weka.clusterers.");
        filename = Utils.removeSubstring(filename, "weka.associations.");
        filename = Utils.removeSubstring(filename, "weka.attributeSelection.");
        filename = Utils.removeSubstring(filename, "weka.estimators.");
        filename = Utils.removeSubstring(filename, "weka.datagenerators.");
        if (!this.m_isDBSaver && !this.m_relationNameForFilename) {
            filename = "";
            try {
                if (this.m_Saver.filePrefix().equals("")) {
                    this.m_Saver.setFilePrefix("no-name");
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        return filename;
    }

    public synchronized void acceptDataSet(DataSetEvent e) {
        block7: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block7;
                StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.statusMessage(stringBuilder.append(Messages.getString("Saver_AcceptDataSet_StatusMessage_Text_First")).toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Saver_AcceptDataSet_LogMessage_Text_First")).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.logMessage(stringBuilder3.append(Messages.getString("Saver_AcceptDataSet_LogMessage_Text_Second")).append(ex.getMessage()).toString());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getDataSet().relationName());
        this.m_dataSet = e.getDataSet();
        if (e.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!e.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
            this.saveBatch();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("Saver_AcceptDataSet_Text_First")).append(this.m_fileName);
            Messages.getInstance();
            System.out.println(stringBuilder4.append(Messages.getString("Saver_AcceptDataSet_Text_Second")).toString());
        }
    }

    public synchronized void acceptDataSet(ThresholdDataEvent e) {
        block6: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block6;
                StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.statusMessage(stringBuilder.append(Messages.getString("Saver_AcceptDataSet_StatusMessage_Text_Second")).toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Saver_AcceptDataSet_LogMessage_Text_Third")).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.logMessage(stringBuilder3.append(Messages.getString("Saver_AcceptDataSet_LogMessage_Text_Fourth")).append(ex.getMessage()).toString());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getDataSet().getPlotInstances().relationName());
        this.m_dataSet = e.getDataSet().getPlotInstances();
        if (this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
            ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
        }
        if (!this.m_isDBSaver) {
            try {
                this.m_Saver.setDirAndPrefix(this.m_fileName, "");
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        this.saveBatch();
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("Saver_AcceptDataSet_Text_Third")).append(this.m_fileName);
        Messages.getInstance();
        System.out.println(stringBuilder4.append(Messages.getString("Saver_AcceptDataSet_Text_Fourth")).toString());
    }

    public synchronized void acceptTestSet(TestSetEvent e) {
        block8: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block8;
                StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.statusMessage(stringBuilder.append(Messages.getString("Saver_AcceptTestSet_StatusMessage_Text_First")).toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Saver_AcceptTestSet_LogMessage_Text_First")).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.logMessage(stringBuilder3.append(Messages.getString("Saver_AcceptTestSet_LogMessage_Text_Second")).append(ex.getMessage()).toString());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getTestSet().relationName());
        this.m_dataSet = e.getTestSet();
        if (e.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!e.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "_test_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            } else {
                ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
                String setName = ((DatabaseSaver)this.m_Saver).getTableName();
                setName = setName.replaceFirst("_[tT][eE][sS][tT]_[0-9]+_[oO][fF]_[0-9]+", "");
                ((DatabaseSaver)this.m_Saver).setTableName(setName + "_test_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
            }
            this.saveBatch();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("Saver_AcceptTestSet_Text_First")).append(e.getSetNumber());
            Messages.getInstance();
            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("Saver_AcceptTestSet_Text_Second")).append(e.getMaxSetNumber());
            Messages.getInstance();
            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("Saver_AcceptTestSet_Text_Third")).append(this.m_fileName);
            Messages.getInstance();
            System.out.println(stringBuilder6.append(Messages.getString("Saver_AcceptTestSet_Text_Fourth")).toString());
        }
    }

    public synchronized void acceptTrainingSet(TrainingSetEvent e) {
        block8: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block8;
                StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.statusMessage(stringBuilder.append(Messages.getString("Saver_AcceptTrainingSet_StatusMessage_Text_First")).toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Saver_AcceptTrainingSet_LogMessage_Text_First")).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.logMessage(stringBuilder3.append(Messages.getString("Saver_AcceptTrainingSet_LogMessage_Text_Second")).append(ex.getMessage()).toString());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getTrainingSet().relationName());
        this.m_dataSet = e.getTrainingSet();
        if (e.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!e.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "_training_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            } else {
                ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
                String setName = ((DatabaseSaver)this.m_Saver).getTableName();
                setName = setName.replaceFirst("_[tT][rR][aA][iI][nN][iI][nN][gG]_[0-9]+_[oO][fF]_[0-9]+", "");
                ((DatabaseSaver)this.m_Saver).setTableName(setName + "_training_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
            }
            this.saveBatch();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("Saver_AcceptTrainingSet_Text_First")).append(e.getSetNumber());
            Messages.getInstance();
            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("Saver_AcceptTrainingSet_Text_Second")).append(e.getMaxSetNumber());
            Messages.getInstance();
            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("Saver_AcceptTrainingSet_Text_Third")).append(this.m_fileName);
            Messages.getInstance();
            System.out.println(stringBuilder6.append(Messages.getString("Saver_AcceptTrainingSet_Text_Fourth")).toString());
        }
    }

    public synchronized void saveBatch() {
        this.m_Saver.setRetrieval(1);
        this.m_ioThread = new SaveBatchThread(this);
        this.m_ioThread.setPriority(1);
        this.m_ioThread.start();
        this.block(true);
    }

    public synchronized void acceptInstance(InstanceEvent e) {
        if (e.getStatus() == 0) {
            block19: {
                try {
                    this.m_Saver = this.makeCopy();
                }
                catch (Exception ex) {
                    if (this.m_logger == null) break block19;
                    StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                    Messages.getInstance();
                    this.m_logger.statusMessage(stringBuilder.append(Messages.getString("Saver_AcceptInstance_StatusMessage_Text_First")).toString());
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Saver_AcceptInstance_LogMessage_Text_First")).append(this.statusMessagePrefix());
                    Messages.getInstance();
                    this.m_logger.logMessage(stringBuilder3.append(Messages.getString("Saver_AcceptInstance_LogMessage_Text_Second")).append(ex.getMessage()).toString());
                }
            }
            this.m_Saver.setRetrieval(2);
            this.m_structure = e.getStructure();
            this.m_fileName = this.sanitizeFilename(this.m_structure.relationName());
            this.m_Saver.setInstances(this.m_structure);
            if (this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
                ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
                ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
            }
        }
        if (e.getStatus() == 1) {
            this.m_visual.setAnimated();
            if (this.m_count == 0) {
                this.passEnvOnToSaver();
                if (!this.m_isDBSaver) {
                    try {
                        this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                        this.m_visual.setStatic();
                    }
                }
                ++this.m_count;
            }
            try {
                this.m_Saver.writeIncremental(e.getInstance());
            }
            catch (Exception ex) {
                this.m_visual.setStatic();
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("Saver_AcceptInstance_Error_Text_First")).append(e.getInstance());
                Messages.getInstance();
                System.err.println(stringBuilder4.append(Messages.getString("Saver_AcceptInstance_Error_Text_Second")).toString());
                ex.printStackTrace();
            }
        }
        if (e.getStatus() == 2) {
            try {
                if (this.m_count == 0) {
                    this.passEnvOnToSaver();
                    if (!this.m_isDBSaver) {
                        try {
                            this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                        }
                        catch (Exception ex) {
                            System.out.println(ex);
                            this.m_visual.setStatic();
                        }
                    }
                    ++this.m_count;
                }
                this.m_Saver.writeIncremental(e.getInstance());
                if (e.getInstance() != null) {
                    this.m_Saver.writeIncremental(null);
                }
                this.m_visual.setStatic();
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("Saver_AcceptInstance_Text_First")).append(this.m_fileName);
                Messages.getInstance();
                System.out.println(stringBuilder5.append(Messages.getString("Saver_AcceptInstance_Text_Second")).toString());
                this.m_count = 0;
            }
            catch (Exception ex) {
                this.m_visual.setStatic();
                Messages.getInstance();
                System.err.println(Messages.getString("Saver_AcceptInstance_Text_Third"));
                ex.printStackTrace();
            }
        }
    }

    public weka.core.converters.Saver getSaverTemplate() {
        return this.m_SaverTemplate;
    }

    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.core.converters.Saver)) {
            StringBuilder stringBuilder = new StringBuilder().append(algorithm.getClass());
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("Saver_SetWrappedAlgorithm_IllegalArgumentException_Text")).toString());
        }
        this.setSaverTemplate((weka.core.converters.Saver)algorithm);
    }

    public Object getWrappedAlgorithm() {
        return this.getSaverTemplate();
    }

    public void setRelationNameForFilename(boolean r) {
        this.m_relationNameForFilename = r;
    }

    public boolean getRelationNameForFilename() {
        return this.m_relationNameForFilename;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_ioThread != null) {
            this.m_ioThread.interrupt();
            this.m_ioThread.stop();
            this.m_ioThread = null;
            this.m_visual.setStatic();
        }
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Saver instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_Saver)).getOptions()) + "|" : "");
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            Saver tv = new Saver();
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class SaveBatchThread
    extends Thread {
        private final DataSink m_DS;

        public SaveBatchThread(DataSink ds) {
            this.m_DS = ds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                StringBuilder stringBuilder;
                Logger logger;
                try {
                    try {
                        Saver.this.m_visual.setAnimated();
                        Saver.this.m_Saver.setInstances(Saver.this.m_dataSet);
                        if (Saver.this.m_logger != null) {
                            Logger logger2 = Saver.this.m_logger;
                            StringBuilder stringBuilder2 = new StringBuilder().append(Saver.this.statusMessagePrefix());
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Saver_SaveBatchThread_Run_StatusMessage_Text_First")).append(Saver.this.m_dataSet.relationName());
                            Messages.getInstance();
                            logger2.statusMessage(stringBuilder3.append(Messages.getString("Saver_SaveBatchThread_Run_StatusMessage_Text_Second")).toString());
                        }
                        Saver.this.m_Saver.writeBatch();
                        if (Saver.this.m_logger != null) {
                            Logger logger3 = Saver.this.m_logger;
                            StringBuilder stringBuilder4 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_First")).append(Saver.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger3.logMessage(stringBuilder5.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Second")).toString());
                        }
                    }
                    catch (Exception ex) {
                        if (Saver.this.m_logger != null) {
                            Logger logger4 = Saver.this.m_logger;
                            StringBuilder stringBuilder6 = new StringBuilder().append(Saver.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger4.statusMessage(stringBuilder6.append(Messages.getString("Saver_SaveBatchThread_Run_StatusMessage_Text_Third")).toString());
                            Logger logger5 = Saver.this.m_logger;
                            StringBuilder stringBuilder7 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder8 = stringBuilder7.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Third")).append(Saver.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger5.logMessage(stringBuilder8.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Fourth")).append(ex.getMessage()).toString());
                        }
                        ex.printStackTrace();
                        Object var3_2 = null;
                        if (Thread.currentThread().isInterrupted() && Saver.this.m_logger != null) {
                            Logger logger6 = Saver.this.m_logger;
                            StringBuilder stringBuilder9 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder10 = stringBuilder9.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Fifth")).append(Saver.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger6.logMessage(stringBuilder10.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Sixth")).toString());
                        }
                        if (Saver.this.m_logger != null) {
                            Logger logger7 = Saver.this.m_logger;
                            StringBuilder stringBuilder11 = new StringBuilder().append(Saver.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger7.statusMessage(stringBuilder11.append(Messages.getString("Saver_SaveBatchThread_Run_StatusMessage_Text_Fourth")).toString());
                        }
                        Saver.this.block(false);
                        Saver.this.m_visual.setStatic();
                        Saver.this.m_ioThread = null;
                        return;
                    }
                    Object var3_1 = null;
                    if (!Thread.currentThread().isInterrupted() || Saver.this.m_logger == null) break block13;
                    logger = Saver.this.m_logger;
                    stringBuilder = new StringBuilder();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (Thread.currentThread().isInterrupted() && Saver.this.m_logger != null) {
                        Logger logger8 = Saver.this.m_logger;
                        StringBuilder stringBuilder12 = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder13 = stringBuilder12.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Fifth")).append(Saver.this.statusMessagePrefix());
                        Messages.getInstance();
                        logger8.logMessage(stringBuilder13.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Sixth")).toString());
                    }
                    if (Saver.this.m_logger != null) {
                        Logger logger9 = Saver.this.m_logger;
                        StringBuilder stringBuilder14 = new StringBuilder().append(Saver.this.statusMessagePrefix());
                        Messages.getInstance();
                        logger9.statusMessage(stringBuilder14.append(Messages.getString("Saver_SaveBatchThread_Run_StatusMessage_Text_Fourth")).toString());
                    }
                    Saver.this.block(false);
                    Saver.this.m_visual.setStatic();
                    Saver.this.m_ioThread = null;
                    throw throwable;
                }
                Messages.getInstance();
                StringBuilder stringBuilder15 = stringBuilder.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Fifth")).append(Saver.this.statusMessagePrefix());
                Messages.getInstance();
                logger.logMessage(stringBuilder15.append(Messages.getString("Saver_SaveBatchThread_Run_LogMessage_Text_Sixth")).toString());
            }
            if (Saver.this.m_logger != null) {
                Logger logger = Saver.this.m_logger;
                StringBuilder stringBuilder = new StringBuilder().append(Saver.this.statusMessagePrefix());
                Messages.getInstance();
                logger.statusMessage(stringBuilder.append(Messages.getString("Saver_SaveBatchThread_Run_StatusMessage_Text_Fourth")).toString());
            }
            Saver.this.block(false);
            Saver.this.m_visual.setStatic();
            Saver.this.m_ioThread = null;
        }
    }
}

