/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.casesDisplay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.casesDisplay.utils.RadioButtonEditor;
import jcolibri.extensions.recommendation.casesDisplay.utils.RadioButtonTableRenderer;
import jcolibri.method.gui.utils.WindowUtils;
import jcolibri.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayCasesTableMethod {
    private static JDialog dialog;
    private static ButtonGroup group;
    private static int returnCode;
    private static CBRCase selectedCase;
    private static JTable table;
    private static CBRCase[] _cases;

    static {
        returnCode = -1;
        selectedCase = null;
    }

    public static UserChoice displayCasesInTableBasic(Collection<CBRCase> cases) {
        return DisplayCasesTableMethod.displayCasesInTable(cases, DisplayOption.BASIC, null);
    }

    public static UserChoice displayCasesInTableEditQuery(Collection<CBRCase> cases) {
        return DisplayCasesTableMethod.displayCasesInTable(cases, DisplayOption.EDIT_QUERY, "Refine Query");
    }

    public static UserChoice displayCasesInTableSelectCase(Collection<CBRCase> cases) {
        return DisplayCasesTableMethod.displayCasesInTable(cases, DisplayOption.SELECT_CASE, "Something like this");
    }

    static UserChoice displayCasesInTable(Collection<CBRCase> cases, DisplayOption displayOption, String optionLabel) {
        _cases = new CBRCase[cases.size()];
        cases.toArray(_cases);
        dialog = new JDialog();
        dialog.setTitle(String.valueOf(cases.size()) + " Retrieved cases");
        dialog.setModal(true);
        if (cases.size() == 0) {
            return new UserChoice(-2, selectedCase);
        }
        Vector<Object> columnNames = DisplayCasesTableMethod.extractColumnNames(cases.iterator().next());
        Vector<Vector> rows = new Vector<Vector>();
        for (CBRCase c : cases) {
            rows.add(DisplayCasesTableMethod.getAttributes(c));
        }
        table = new JTable(rows, (Vector)columnNames){
            private static final long serialVersionUID = 1L;

            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        table.getColumn("Select").setCellRenderer(new RadioButtonTableRenderer());
        table.getColumn("Select").setCellEditor(new RadioButtonEditor(new JCheckBox()));
        group = new ButtonGroup();
        TableModel tm = table.getModel();
        int i = 0;
        while (i < tm.getRowCount()) {
            group.add((JRadioButton)tm.getValueAt(i, 0));
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout(new BoxLayout(actionsPanel, 0));
        JButton ok = new JButton("Add to Basket");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (table.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(dialog, "You should choose one item", "Error", 0);
                } else {
                    returnCode = -3;
                    selectedCase = _cases[table.getSelectedRow()];
                    dialog.setVisible(false);
                }
            }
        });
        JButton quit = new JButton("Quit");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                returnCode = -1;
                dialog.setVisible(false);
            }
        });
        JButton refine = new JButton(optionLabel);
        refine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                returnCode = -2;
                dialog.setVisible(false);
            }
        });
        JButton select = new JButton(optionLabel);
        select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (table.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(dialog, "You should choose one item", "Error", 0);
                } else {
                    returnCode = -2;
                    selectedCase = _cases[table.getSelectedRow()];
                    dialog.setVisible(false);
                }
            }
        });
        actionsPanel.add(Box.createHorizontalGlue());
        actionsPanel.add(ok);
        actionsPanel.add(quit);
        if (displayOption == DisplayOption.EDIT_QUERY) {
            actionsPanel.add(refine);
        }
        if (displayOption == DisplayOption.SELECT_CASE) {
            actionsPanel.add(select);
        }
        actionsPanel.add(Box.createHorizontalGlue());
        mainPanel.add((Component)actionsPanel, "South");
        dialog.getContentPane().add(mainPanel);
        dialog.setSize(800, 200);
        WindowUtils.centerWindow(dialog);
        dialog.setVisible(true);
        return new UserChoice(returnCode, selectedCase);
    }

    private static Vector getAttributes(CBRCase c) {
        Vector<Object> res = new Vector<Object>();
        JRadioButton rb = new JRadioButton(c.getID().toString());
        res.add(rb);
        DisplayCasesTableMethod.getAttributes(c.getDescription(), res);
        DisplayCasesTableMethod.getAttributes(c.getSolution(), res);
        DisplayCasesTableMethod.getAttributes(c.getJustificationOfSolution(), res);
        DisplayCasesTableMethod.getAttributes(c.getResult(), res);
        return res;
    }

    private static void getAttributes(CaseComponent cc, Vector<Object> res) {
        Collection<Attribute> atts = AttributeUtils.getAttributes(cc);
        if (atts == null) {
            return;
        }
        Attribute id = cc.getIdAttribute();
        for (Attribute a : atts) {
            if (a.equals(id)) continue;
            res.add(AttributeUtils.findValue(a, cc));
        }
    }

    private static Vector<Object> extractColumnNames(CBRCase c) {
        Vector<Object> res = new Vector<Object>();
        res.add("Select");
        DisplayCasesTableMethod.extractColumnNames(c.getDescription(), res);
        DisplayCasesTableMethod.extractColumnNames(c.getSolution(), res);
        DisplayCasesTableMethod.extractColumnNames(c.getJustificationOfSolution(), res);
        DisplayCasesTableMethod.extractColumnNames(c.getResult(), res);
        return res;
    }

    private static void extractColumnNames(CaseComponent cc, Vector<Object> res) {
        Collection<Attribute> atts = AttributeUtils.getAttributes(cc);
        if (atts == null) {
            return;
        }
        Attribute id = cc.getIdAttribute();
        for (Attribute a : atts) {
            if (a.equals(id)) continue;
            res.add(a.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayOption {
        BASIC,
        EDIT_QUERY,
        SELECT_CASE;

    }
}

