/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.revise.classification;

import java.util.Collection;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.KNNClassificationMethod;
import jcolibri.method.revise.classification.ClassificationOracle;

public class BasicClassificationOracle
implements ClassificationOracle {
    public boolean isCorrectPrediction(ClassificationSolution predictedSolution, CBRCase testCase) {
        ClassificationSolution correctSolution = (ClassificationSolution)testCase.getSolution();
        return this.isCorrectPrediction(predictedSolution, correctSolution);
    }

    public boolean isCorrectPrediction(ClassificationSolution predictedSolution, ClassificationSolution correctSolution) {
        return predictedSolution.getClassification().equals(correctSolution.getClassification());
    }

    public boolean isCorrectPrediction(CBRQuery query, CBRCaseBase caseBase, KNNClassificationConfig knnConfig) {
        Collection<CBRCase> cases = caseBase.getCases();
        Collection<RetrievalResult> knn = NNScoringMethod.evaluateSimilarity(cases, query, knnConfig);
        knn = SelectCases.selectTopKRR(knn, knnConfig.getK());
        KNNClassificationMethod classifier = knnConfig.getClassificationMethod();
        ClassificationSolution predictedSolution = classifier.getPredictedSolution(knn);
        return this.isCorrectPrediction(predictedSolution, (CBRCase)query);
    }

    public double getPredictionCost(ClassificationSolution predictedSolution, CBRCase testCase) {
        ClassificationSolution correctSolution = (ClassificationSolution)testCase.getSolution();
        return this.getPredictionCost(predictedSolution, correctSolution);
    }

    public double getPredictionCost(ClassificationSolution predictedSolution, ClassificationSolution correctSolution) {
        return !this.isCorrectPrediction(predictedSolution, correctSolution) ? 1 : 0;
    }

    public double getPredictionCost(CBRQuery query, CBRCaseBase caseBase, KNNClassificationConfig knnConfig) {
        Collection<CBRCase> cases = caseBase.getCases();
        Collection<RetrievalResult> knn = NNScoringMethod.evaluateSimilarity(cases, query, knnConfig);
        knn = SelectCases.selectTopKRR(knn, knnConfig.getK());
        KNNClassificationMethod classifier = knnConfig.getClassificationMethod();
        ClassificationSolution predictedSolution = classifier.getPredictedSolution(knn);
        return this.getPredictionCost(predictedSolution, (CBRCase)query);
    }
}

