/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.algorithms;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jcolibri.cbrcore.CBRCase;
import jcolibri.exception.InitializingException;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.maintenance.AbstractCaseBaseEditMethod;
import jcolibri.method.maintenance.CaseResult;
import jcolibri.method.maintenance.CompetenceModel;
import jcolibri.method.maintenance.solvesFunctions.CBESolvesFunction;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.KNNClassificationMethod;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBNRNoiseReduction
extends AbstractCaseBaseEditMethod {
    public LinkedList<CBRCase> retrieveCasesToDelete(Collection<CBRCase> cases, KNNClassificationConfig simConfig) {
        ProgressController.init(this.getClass(), "Blame-based Noise Reduction (BBNR)", -1);
        LinkedList<CBRCase> localCases = new LinkedList<CBRCase>();
        for (CBRCase c : cases) {
            localCases.add(c);
        }
        CompetenceModel sc = new CompetenceModel();
        sc.computeCompetenceModel(new CBESolvesFunction(), simConfig, localCases);
        List<CaseResult> caseLiabilitySetSizes = new LinkedList<CaseResult>();
        for (CBRCase c : localCases) {
            Collection<CBRCase> currLiabilitySet = null;
            try {
                currLiabilitySet = sc.getLiabilitySet(c);
            }
            catch (InitializingException e) {
                e.printStackTrace();
            }
            int liabilitySetSize = 0;
            if (currLiabilitySet != null) {
                liabilitySetSize = currLiabilitySet.size();
            }
            caseLiabilitySetSizes.add(new CaseResult(c, (double)liabilitySetSize));
            ProgressController.step(this.getClass());
        }
        caseLiabilitySetSizes = CaseResult.sortResults(false, caseLiabilitySetSizes);
        LinkedList<CBRCase> allCasesToBeRemoved = new LinkedList<CBRCase>();
        ListIterator<CaseResult> liabIter = caseLiabilitySetSizes.listIterator();
        while (liabIter.hasNext()) {
            CaseResult highestLiability = liabIter.next();
            if (highestLiability.getResult() <= 0.0) break;
            CBRCase removed = highestLiability.getCase();
            localCases.remove(removed);
            Collection<CBRCase> covSet = null;
            try {
                covSet = sc.getCoverageSet(removed);
            }
            catch (InitializingException e) {
                e.printStackTrace();
            }
            boolean caseMisclassified = false;
            for (CBRCase query : covSet) {
                Collection<RetrievalResult> knn = NNScoringMethod.evaluateSimilarity(localCases, query, simConfig);
                knn = SelectCases.selectTopKRR(knn, simConfig.getK());
                try {
                    KNNClassificationMethod classifier = simConfig.getClassificationMethod();
                    ClassificationSolution predictedSolution = classifier.getPredictedSolution(knn);
                    BasicClassificationOracle oracle = new BasicClassificationOracle();
                    if (oracle.isCorrectPrediction(predictedSolution, query)) continue;
                    caseMisclassified = true;
                    break;
                }
                catch (ClassCastException cce) {
                    LogFactory.getLog(BBNRNoiseReduction.class).error((Object)cce);
                    System.exit(0);
                }
            }
            if (caseMisclassified) {
                localCases.add(removed);
            } else {
                allCasesToBeRemoved.add(removed);
            }
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
        return allCasesToBeRemoved;
    }
}

