/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.solvesFunctions;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jcolibri.cbrcore.CBRCase;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.maintenance.SolvesFunction;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.KNNClassificationMethod;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBESolvesFunction
extends SolvesFunction {
    @Override
    public void setCasesThatSolveAndMisclassifyQ(CBRCase q, Collection<CBRCase> cases, KNNClassificationConfig knnConfig) {
        this.solveQ = new LinkedList();
        this.misclassifyQ = null;
        this.solveQ.add(q);
        knnConfig.setK(knnConfig.getK() + 1);
        Collection<RetrievalResult> knnResults = NNScoringMethod.evaluateSimilarity(cases, q, knnConfig);
        Collection<CBRCase> knn = SelectCases.selectTopK(knnResults, knnConfig.getK());
        knnConfig.setK(knnConfig.getK() - 1);
        RetrievalResult result = null;
        boolean qFound = false;
        Iterator<RetrievalResult> cIter = knnResults.iterator();
        while (cIter.hasNext() && !qFound) {
            result = cIter.next();
            if (!result.get_case().equals(q)) continue;
            knnResults.remove(result);
            qFound = true;
        }
        if (!qFound) {
            knn.remove(result);
        }
        try {
            KNNClassificationMethod classifier = knnConfig.getClassificationMethod();
            ClassificationSolution predictedSolution = classifier.getPredictedSolution(knnResults);
            BasicClassificationOracle oracle = new BasicClassificationOracle();
            boolean correct = oracle.isCorrectPrediction(predictedSolution, q);
            if (correct) {
                for (RetrievalResult res : knnResults) {
                    CBRCase c = res.get_case();
                    if (!oracle.isCorrectPrediction((ClassificationSolution)c.getSolution(), q)) continue;
                    this.solveQ.add(c);
                }
            } else {
                this.misclassifyQ = new LinkedList();
                for (RetrievalResult res : knnResults) {
                    CBRCase c = res.get_case();
                    if (oracle.isCorrectPrediction((ClassificationSolution)c.getSolution(), q)) continue;
                    this.misclassifyQ.add(c);
                }
            }
        }
        catch (ClassCastException cce) {
            LogFactory.getLog(CBESolvesFunction.class).error((Object)cce);
            System.exit(0);
        }
    }
}

