/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.extensions.textual.IE.representation.info.WeightedRelation;
import jcolibri.extensions.textual.stemmer.Stemmer;
import jcolibri.util.AttributeUtils;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryLinker {
    protected static ArrayList<GlossaryTriple> glossary;

    public static void LinkWithGlossary(Collection<CBRCase> cases, CBRQuery query) {
        LogFactory.getLog(GlossaryLinker.class).info((Object)"Linking tokens with user glossary.");
        ProgressController.init(GlossaryLinker.class, "Linking tokens with user glossary ...", cases.size());
        ArrayList<IEText> queryTexts = new ArrayList<IEText>();
        IEutils.addTexts(query.getDescription(), queryTexts);
        for (CBRCase c : cases) {
            ArrayList<IEText> caseTexts = new ArrayList<IEText>();
            IEutils.addTexts(c.getDescription(), caseTexts);
            int i = 0;
            while (i < queryTexts.size()) {
                IEText queryText = (IEText)queryTexts.get(i);
                IEText caseText = (IEText)caseTexts.get(i);
                GlossaryLinker.linkWithGlossary(caseText, queryText);
                ++i;
            }
            ProgressController.step(GlossaryLinker.class);
        }
        ProgressController.finish(GlossaryLinker.class);
    }

    public static void linkWithGlossary(Collection<CBRCase> cases, CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(GlossaryLinker.class).info((Object)"Linking tokens with user glossary.");
        ProgressController.init(GlossaryLinker.class, "Linking tokens with user glossary ...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute at : attributes) {
                CaseComponent caseCC = AttributeUtils.findBelongingComponent(at, c);
                CaseComponent queryCC = AttributeUtils.findBelongingComponent(at, query);
                try {
                    IEText queryText = (IEText)at.getValue(queryCC);
                    IEText caseText = (IEText)at.getValue(caseCC);
                    GlossaryLinker.linkWithGlossary(caseText, queryText);
                }
                catch (AttributeAccessException e) {
                    LogFactory.getLog(GlossaryLinker.class).error((Object)e);
                }
            }
            ProgressController.step(GlossaryLinker.class);
        }
        ProgressController.finish(GlossaryLinker.class);
    }

    public static void linkWithGlossary(IEText caseText, IEText queryText) {
        List<Token> queryTokens = queryText.getAllTokens();
        List<Token> caseTokens = caseText.getAllTokens();
        for (GlossaryTriple gt : glossary) {
            String posTag = gt._posTag;
            Set<String> words = gt._words;
            int weight = gt._weight;
            for (Token queryTok : queryTokens) {
                String queryPOS;
                String queryStem = queryTok.getStem();
                if (!words.contains(queryStem) || !(queryPOS = GlossaryLinker.lookupGlossaryPos(queryTok.getPostag())).equals(posTag)) continue;
                for (Token caseTok : caseTokens) {
                    String casePOS;
                    String caseStem = caseTok.getStem();
                    if (!words.contains(caseStem) || caseStem.equals(queryStem) || !queryPOS.equals(casePOS = GlossaryLinker.lookupGlossaryPos(caseTok.getPostag()))) continue;
                    queryTok.addRelation(new WeightedRelation(queryTok, caseTok, 1 / weight));
                    LogFactory.getLog(GlossaryLinker.class).info((Object)("Adding relation: " + queryTok.getRawContent() + " --> " + caseTok.getRawContent() + ". Weight: " + 1 / weight));
                }
            }
        }
    }

    public static void loadGlossary(String filename) {
        glossary = new ArrayList();
        try {
            URL file = FileIO.findFile(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(file.openStream()));
            String line = "";
            Stemmer stemmer = new Stemmer();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                int pos = line.indexOf(93);
                if (pos == -1) {
                    throw new Exception(String.valueOf(line) + "  POSTag field not found");
                }
                String _posTag = line.substring(1, pos);
                String _rest = line.substring(pos + 1);
                if ((pos = _rest.indexOf(125)) == -1) {
                    throw new Exception(String.valueOf(line) + "  Weight field not found");
                }
                String _weight = _rest.substring(1, pos);
                int weight = Integer.parseInt(_weight);
                String _words = _rest.substring(pos + 1);
                StringTokenizer st = new StringTokenizer(_words, " ");
                HashSet<String> words = new HashSet<String>();
                while (st.hasMoreTokens()) {
                    String sw = st.nextToken();
                    words.add(stemmer.stem(sw));
                }
                glossary.add(new GlossaryTriple(_posTag, words, weight));
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(GlossaryLinker.class).error((Object)e);
        }
    }

    static String lookupGlossaryPos(String tag) {
        if (tag.equals("NN") || tag.equals("NNS")) {
            return "NOUN";
        }
        if (tag.startsWith("V")) {
            return "VERB";
        }
        if (tag.startsWith("J")) {
            return "ADJECTIVE";
        }
        if (tag.startsWith("RB")) {
            return "ADVERB";
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlossaryTriple {
        String _posTag;
        Set<String> _words;
        int _weight;

        GlossaryTriple(String p, Set<String> wor, int w) {
            this._posTag = p;
            this._words = wor;
            this._weight = w;
        }
    }
}

