/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test13.similarity;

import java.util.ArrayList;
import java.util.StringTokenizer;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class AverageMultipleTextValues
implements LocalSimilarityFunction {
    double _interval;

    public AverageMultipleTextValues(double interval) {
        this._interval = interval;
    }

    private double extractStringAverage(String s) {
        ArrayList<Double> list = new ArrayList<Double>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String num = st.nextToken();
            double dnum = 0.0;
            try {
                dnum = Double.parseDouble(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dnum == 0.0) {
                try {
                    dnum = Integer.parseInt(num);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            list.add(new Double(dnum));
        }
        double total = list.size();
        if (total == 0.0) {
            return 0.0;
        }
        double acum = 0.0;
        for (Double Dnum : list) {
            acum += Dnum.doubleValue();
        }
        return acum / total;
    }

    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof String)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof String)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        String caseS = (String)caseObject;
        String queryS = (String)queryObject;
        if (queryS.length() == 0) {
            return 0.0;
        }
        if (caseS.length() == 0) {
            return 0.0;
        }
        double qV = this.extractStringAverage(queryS);
        double cV = this.extractStringAverage(caseS);
        return 1.0 - Math.abs(qV - cV) / this._interval;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof String;
        }
        if (o2 == null) {
            return o1 instanceof String;
        }
        return o1 instanceof String && o2 instanceof String;
    }
}

