/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.solvesFunctions;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jcolibri.cbrcore.CBRCase;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.maintenance.SolvesFunction;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.revise.classification.BasicClassificationOracle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICFSolvesFunction
extends SolvesFunction {
    @Override
    public void setCasesThatSolveAndMisclassifyQ(CBRCase q, Collection<CBRCase> cases, KNNClassificationConfig knnConfig) {
        this.solveQ = new LinkedList();
        this.misclassifyQ = null;
        knnConfig.setK(Integer.MAX_VALUE);
        Collection<RetrievalResult> orderedRetrievedCases = NNScoringMethod.evaluateSimilarity(cases, q, knnConfig);
        orderedRetrievedCases = SelectCases.selectTopKRR(orderedRetrievedCases, knnConfig.getK());
        BasicClassificationOracle oracle = new BasicClassificationOracle();
        boolean disagreeingCaseFound = false;
        Iterator<RetrievalResult> iter = orderedRetrievedCases.iterator();
        while (!disagreeingCaseFound && iter.hasNext()) {
            CBRCase c = iter.next().get_case();
            ClassificationSolution cSol = (ClassificationSolution)c.getSolution();
            if (oracle.isCorrectPrediction(cSol, q)) {
                this.solveQ.add(c);
                continue;
            }
            disagreeingCaseFound = true;
        }
    }
}

