/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec4;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.conditionals.DisplayCasesIfNumber;
import jcolibri.extensions.recommendation.navigationByAsking.InformationGain;
import jcolibri.extensions.recommendation.navigationByAsking.ObtainQueryWithAttributeQuestionMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal;
import jcolibri.test.recommenders.rec4.housesData.HouseDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Houses4
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    FilterConfig filterConfig;
    Map<Attribute, String> labels;

    @Override
    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/rec4/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.filterConfig = new FilterConfig();
        this.filterConfig.addPredicate(new Attribute("area", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("beds", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("priceRange", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("furnished", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("type", HouseDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("baths", HouseDescription.class), new Equal());
        this.labels = new HashMap<Attribute, String>();
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        Collection<CBRCase> workingCases = this._caseBase.getCases();
        Attribute att = InformationGain.getMoreIGattribute(workingCases, true, this._caseBase.getCases());
        boolean _continue = ObtainQueryWithAttributeQuestionMethod.obtainQueryWithAttributeQuestion(query, att, this.labels, workingCases);
        this.sequence1(query, _continue);
    }

    public void sequence1(CBRQuery query, boolean _continue) throws ExecutionException {
        Collection<CBRCase> workingCases = FilterBasedRetrievalMethod.filterCases(this._caseBase.getCases(), query, this.filterConfig);
        if (DisplayCasesIfNumber.displayCases(50, 1, workingCases, false)) {
            this.sequence2(query, workingCases, _continue);
        } else {
            this.sequence3(query, workingCases);
        }
    }

    public void sequence2(CBRQuery query, Collection<CBRCase> workingCases, boolean _continue) throws ExecutionException {
        UserChoice choice = _continue ? DisplayCasesTableMethod.displayCasesInTableEditQuery(workingCases) : DisplayCasesTableMethod.displayCasesInTableBasic(workingCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence3(query, workingCases);
        } else {
            this.sequence4(choice, workingCases);
        }
    }

    public void sequence3(CBRQuery query, Collection<CBRCase> workingCases) throws ExecutionException {
        Attribute att = InformationGain.getMoreIGattribute(workingCases, false, this._caseBase.getCases());
        boolean _continue = ObtainQueryWithAttributeQuestionMethod.obtainQueryWithAttributeQuestion(query, att, this.labels, workingCases);
        this.sequence1(query, _continue);
    }

    public void sequence4(UserChoice choice, Collection<CBRCase> workingCases) throws ExecutionException {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Houses4 recommender = new Houses4();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            query.setDescription(hd);
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(Houses4.class).error((Object)e);
        }
    }
}

