/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.info.FeatureInfo;
import jcolibri.extensions.textual.IE.representation.info.PhraseInfo;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicInformationExtractor {
    public static void extractInformation(Collection<CBRCase> cases) {
        LogFactory.getLog(BasicInformationExtractor.class).info((Object)"Extracting cases information.");
        ProgressController.init(BasicInformationExtractor.class, "Extracting cases information ...", cases.size());
        for (CBRCase c : cases) {
            BasicInformationExtractor.extractInformation(c.getDescription());
            BasicInformationExtractor.extractInformation(c.getSolution());
            BasicInformationExtractor.extractInformation(c.getDescription());
            BasicInformationExtractor.extractInformation(c.getDescription());
            ProgressController.step(BasicInformationExtractor.class);
        }
        ProgressController.finish(BasicInformationExtractor.class);
    }

    public static void extractInformation(CBRQuery query) {
        LogFactory.getLog(BasicInformationExtractor.class).info((Object)"Extracting query information.");
        BasicInformationExtractor.extractInformation(query.getDescription());
    }

    private static void extractInformation(CaseComponent cc) {
        if (cc == null) {
            return;
        }
        try {
            Attribute[] attrs = AttributeUtils.getAttributes(cc.getClass());
            ArrayList<IEText> texts = new ArrayList<IEText>();
            ArrayList<Attribute> other = new ArrayList<Attribute>();
            int i = 0;
            while (i < attrs.length) {
                Object o = attrs[i].getValue(cc);
                if (o instanceof CaseComponent) {
                    BasicInformationExtractor.extractInformation((CaseComponent)o);
                } else if (o instanceof IEText) {
                    texts.add((IEText)o);
                } else {
                    other.add(attrs[i]);
                }
                ++i;
            }
            ArrayList<PhraseInfo> phrases = new ArrayList<PhraseInfo>();
            ArrayList<FeatureInfo> features = new ArrayList<FeatureInfo>();
            for (IEText text : texts) {
                phrases.addAll(text.getPhrases());
                features.addAll(text.getFeatures());
            }
            for (Attribute at : other) {
                String name = at.getName();
                if (at.getType().equals(String.class)) {
                    String value = "";
                    for (FeatureInfo feature : features) {
                        if (!feature.getFeature().equalsIgnoreCase(name)) continue;
                        value = String.valueOf(value) + feature.getValue() + " ";
                    }
                    if (value.length() <= 0) continue;
                    at.setValue(cc, value);
                    LogFactory.getLog(BasicInformationExtractor.class).debug((Object)("Adding features to attribute: " + at.getName() + " <- " + value));
                    continue;
                }
                if (!at.getType().equals(Boolean.class)) continue;
                Boolean phrase = new Boolean(false);
                Iterator iter = phrases.iterator();
                while (iter.hasNext() && !phrase.booleanValue()) {
                    PhraseInfo p = (PhraseInfo)iter.next();
                    if (!p.getPhrase().equalsIgnoreCase(name)) continue;
                    phrase = Boolean.TRUE;
                    at.setValue(cc, phrase);
                    LogFactory.getLog(BasicInformationExtractor.class).debug((Object)("Enabling attribute: " + at.getName() + ". Source: " + p.getPhrase()));
                }
            }
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(BasicInformationExtractor.class).error((Object)e);
        }
    }
}

