/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.creole.ExecutionException;
import gate.creole.gazetteer.DefaultGazetteer;
import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.gate.IETextGate;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.extensions.textual.IE.representation.info.PhraseInfo;
import jcolibri.util.AttributeUtils;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatePhrasesExtractor {
    private static DefaultGazetteer gaze = null;
    private static String defaultRulesFileName = "jcolibri/extensions/textual/IE/gate/gateinit/plugins/ANNIE/resources/gazetteer/lists.def";

    public static void extractPhrases(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(GatePhrasesExtractor.class).info((Object)"Extracting phrases.");
        ProgressController.init(GatePhrasesExtractor.class, "Extracting phrases", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                if (!(o instanceof IETextGate)) continue;
                GatePhrasesExtractor.extractPhrases((IETextGate)o);
            }
            ProgressController.step(GatePhrasesExtractor.class);
        }
        ProgressController.finish(GatePhrasesExtractor.class);
    }

    public static void extractPhrases(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(GatePhrasesExtractor.class).info((Object)"Extracting phrases.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            if (!(o instanceof IETextGate)) continue;
            GatePhrasesExtractor.extractPhrases((IETextGate)o);
        }
    }

    public static void extractPhrases(Collection<CBRCase> cases) {
        LogFactory.getLog(GatePhrasesExtractor.class).info((Object)"Extracting phrases.");
        ProgressController.init(GatePhrasesExtractor.class, "Extracting phrases", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                if (!(t instanceof IETextGate)) continue;
                GatePhrasesExtractor.extractPhrases((IETextGate)t);
            }
            ProgressController.step(GatePhrasesExtractor.class);
        }
        ProgressController.finish(GatePhrasesExtractor.class);
    }

    public static void extractPhrases(CBRQuery query) {
        LogFactory.getLog(GatePhrasesExtractor.class).info((Object)"Extracting phrases.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            if (!(t instanceof IETextGate)) continue;
            GatePhrasesExtractor.extractPhrases((IETextGate)t);
        }
    }

    public static void extractPhrases(IETextGate text) {
        try {
            gaze.setDocument(text.getDocument());
            gaze.execute();
            AnnotationSet lookupAnnotations = text.getDocument().getAnnotations().get("Lookup");
            for (Token t : text.getAllTokens()) {
                Annotation anotToken = text.getTokenMapping(t);
                AnnotationSet lookupAnnots = lookupAnnotations.get(anotToken.getStartNode().getOffset(), anotToken.getEndNode().getOffset());
                for (Annotation anot : lookupAnnots) {
                    String Type2 = (String)anot.getFeatures().get((Object)"majorType");
                    String minorType = (String)anot.getFeatures().get((Object)"minorType");
                    if (minorType != null) {
                        Type2 = String.valueOf(Type2) + "." + minorType;
                    }
                    text.addPhrase(new PhraseInfo(Type2, anot.getStartNode().getOffset().intValue(), anot.getEndNode().getOffset().intValue()));
                }
            }
        }
        catch (ExecutionException e) {
            LogFactory.getLog(GatePhrasesExtractor.class).error((Object)e);
        }
    }

    public static void loadDefaultRules() {
        GatePhrasesExtractor.loadRules(defaultRulesFileName);
    }

    public static void loadRules(String filename) {
        try {
            gaze = (DefaultGazetteer)Factory.createResource((String)"gate.creole.gazetteer.DefaultGazetteer");
            gaze.setListsURL(FileIO.findFile(filename));
            gaze.init();
        }
        catch (Exception e) {
            LogFactory.getLog(GatePhrasesExtractor.class).error((Object)e);
        }
    }
}

