/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import jcolibri.extensions.textual.lucene.LuceneDocument;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndex {
    private Directory directory;
    private HashMap<String, LuceneDocument> docsMapping = new HashMap();

    public LuceneIndex(File directory, Collection<LuceneDocument> documents) {
        LogFactory.getLog(LuceneIndex.class).info((Object)("Creating File System Index in: " + directory.getPath()));
        try {
            this.directory = FSDirectory.getDirectory((File)directory);
        }
        catch (IOException e) {
            LogFactory.getLog(LuceneIndex.class).error((Object)e);
        }
        this.createIndex(documents);
    }

    public LuceneIndex(Collection<LuceneDocument> documents) {
        LogFactory.getLog(LuceneIndex.class).info((Object)"Creating In-Memory index");
        this.directory = new RAMDirectory();
        this.createIndex(documents);
    }

    private void createIndex(Collection<LuceneDocument> documents) {
        try {
            IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), true);
            LogFactory.getLog(LuceneIndex.class).info((Object)("Indexing " + documents.size() + " documents."));
            ProgressController.init(this.getClass(), "Lucene. Indexing documents", documents.size());
            for (LuceneDocument doc : documents) {
                writer.addDocument(doc.getInternalDocument());
                this.docsMapping.put(doc.getDocID(), doc);
                ProgressController.step(this.getClass());
            }
            LogFactory.getLog(LuceneIndex.class).info((Object)"Optimizing index.");
            writer.optimize();
            writer.close();
            ProgressController.finish(this.getClass());
        }
        catch (Exception e) {
            LogFactory.getLog(LuceneIndex.class).error((Object)e);
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public int getNumberOfDocuments() {
        return this.docsMapping.size();
    }

    public LuceneDocument getDocument(String docId) {
        return this.docsMapping.get(docId);
    }
}

