/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.cbrcore;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import jcolibri.exception.AttributeAccessException;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private Field field;

    public Attribute(Field f) {
        this.field = f;
    }

    public Attribute(String attributeName, Class _class) {
        try {
            this.field = _class.getDeclaredField(attributeName);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)(e + "Attribute: " + attributeName + " Class:" + _class.getName()));
        }
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Object getValue(Object obj) throws AttributeAccessException {
        Object res = null;
        try {
            res = this.field.get(obj);
            return res;
        }
        catch (Exception exception) {
            try {
                PropertyDescriptor pd = new PropertyDescriptor(this.field.getName(), this.field.getDeclaringClass());
                res = pd.getReadMethod().invoke(obj, null);
                return res;
            }
            catch (Exception exception2) {
                throw new AttributeAccessException("Error getting value from object: " + obj + ", attribute: " + this.field.getName());
            }
        }
    }

    public void setValue(Object obj, Object value) throws AttributeAccessException {
        try {
            this.field.set(obj, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PropertyDescriptor pd = new PropertyDescriptor(this.field.getName(), this.field.getDeclaringClass());
            Object[] args = new Object[]{value};
            pd.getWriteMethod().invoke(obj, args);
        }
        catch (Exception e) {
            throw new AttributeAccessException("Error setting value from object: " + obj + ", attribute: " + this.field.getName());
        }
    }

    public int hashCode() {
        return this.field.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        return this.field.getName().equals(((Attribute)o).getName()) && this.field.getDeclaringClass().equals(((Attribute)o).getDeclaringClass());
    }
}

