/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.gate.GatePhrasesExtractor;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.info.PhraseInfo;
import jcolibri.util.AttributeUtils;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhrasesExtractor {
    static HashMap<String, Pattern> rulesList;

    public static void extractPhrases(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(PhrasesExtractor.class).info((Object)"Extracting phrases.");
        ProgressController.init(PhrasesExtractor.class, "Extracting phrases ...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                PhrasesExtractor.extractPhrases((IEText)o);
            }
            ProgressController.step(GatePhrasesExtractor.class);
        }
        ProgressController.finish(GatePhrasesExtractor.class);
    }

    public static void extractPhrases(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(PhrasesExtractor.class).info((Object)"Extracting phrases.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            PhrasesExtractor.extractPhrases((IEText)o);
        }
    }

    public static void extractPhrases(Collection<CBRCase> cases) {
        LogFactory.getLog(PhrasesExtractor.class).info((Object)"Extracting phrases.");
        ProgressController.init(PhrasesExtractor.class, "Extracting phrases ...", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                PhrasesExtractor.extractPhrases(t);
            }
            ProgressController.step(GatePhrasesExtractor.class);
        }
        ProgressController.finish(GatePhrasesExtractor.class);
    }

    public static void extractPhrases(CBRQuery query) {
        LogFactory.getLog(PhrasesExtractor.class).info((Object)"Extracting phrases.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            PhrasesExtractor.extractPhrases(t);
        }
    }

    public static void extractPhrases(IEText text) {
        String rawText = text.getRAWContent();
        for (String rule : rulesList.keySet()) {
            Pattern pattern = rulesList.get(rule);
            Matcher m = pattern.matcher(rawText);
            while (m.find()) {
                text.addPhrase(new PhraseInfo(rule, m.start(), m.end()));
            }
        }
    }

    public static void loadRules(String filename) {
        try {
            URL file = FileIO.findFile(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(file.openStream()));
            rulesList = new HashMap();
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                int pos = line.indexOf(93);
                if (pos == -1) {
                    throw new Exception(String.valueOf(line) + "  Feature field not found");
                }
                String _feature = line.substring(1, pos);
                String _rule = line.substring(pos + 1);
                rulesList.put(PhrasesExtractor.cleanSpaces(_feature), Pattern.compile(_rule));
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(PhrasesExtractor.class).error((Object)e);
        }
    }

    private static String cleanSpaces(String w) {
        String res = "";
        StringTokenizer st = new StringTokenizer(w, " ");
        while (st.hasMoreTokens()) {
            res = String.valueOf(res) + st.nextToken();
            if (!st.hasMoreTokens()) continue;
            res = String.valueOf(res) + " ";
        }
        return res;
    }
}

