/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.ontology;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import jcolibri.datatypes.Instance;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntDeepBasic;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;
import org.apache.commons.logging.LogFactory;

public class OntDetail
implements LocalSimilarityFunction {
    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof Instance)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof Instance)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        Instance i1 = (Instance)caseObject;
        Instance i2 = (Instance)queryObject;
        if (i1.equals(i2)) {
            return 1.0;
        }
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        HashSet<String> sc1 = new HashSet<String>();
        Iterator iter = ob.listBelongingClasses(i1.toString());
        while (iter.hasNext()) {
            sc1.add((String)iter.next());
        }
        sc1.remove(ob.getThingURI());
        HashSet<String> sc2 = new HashSet<String>();
        Iterator iter2 = ob.listBelongingClasses(i2.toString());
        while (iter2.hasNext()) {
            sc2.add((String)iter2.next());
        }
        sc2.remove(ob.getThingURI());
        sc1.retainAll(sc2);
        double intersectionsize = sc1.size();
        double res = 1.0 - 1.0 / (2.0 * intersectionsize);
        return res;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Instance;
        }
        if (o2 == null) {
            return o1 instanceof Instance;
        }
        return o1 instanceof Instance && o2 instanceof Instance;
    }

    public static void main(String[] args) {
        try {
            OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
            ob.initWithPelletReasoner();
            OntologyDocument mainOnto = new OntologyDocument("http://gaia.fdi.ucm.es/ontologies/vacation.owl", FileIO.findFile("jcolibri/test/test5/vacation.owl").toExternalForm());
            ArrayList subOntologies = new ArrayList();
            ob.loadOntology(mainOnto, subOntologies, false);
            OntDetail sim = new OntDetail();
            System.out.println("detail(CAR,TRAIN)=" + sim.compute(new Instance("CAR"), new Instance("TRAIN")));
            System.out.println("detail(CAR,IBIZA)=" + sim.compute(new Instance("CAR"), new Instance("IBIZA")));
            System.out.println("detail(CAR,I101)=" + sim.compute(new Instance("CAR"), new Instance("I101")));
        }
        catch (Exception e) {
            LogFactory.getLog(OntDeepBasic.class).error((Object)e);
        }
    }
}

