/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.maintenance_evaluation.evaluators;

import java.util.ArrayList;
import java.util.Date;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.maintenance_evaluation.MaintenanceEvaluator;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

public class MaintenanceLeaveOneOutEvaluator
extends MaintenanceEvaluator {
    public void LeaveOneOut() {
        try {
            ArrayList<CBRCase> aux = new ArrayList<CBRCase>();
            long t = new Date().getTime();
            int numberOfCycles = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
            CBRCaseBase caseBase = this.app.preCycle();
            if (!(caseBase instanceof CachedLinealCaseBase)) {
                LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
            }
            this.prepareCases(caseBase);
            ArrayList<CBRCase> cases = new ArrayList<CBRCase>(caseBase.getCases());
            ProgressController.init(this.getClass(), "LeaveOneOut Evaluation", cases.size());
            for (CBRCase _case : cases) {
                aux.clear();
                aux.add(_case);
                caseBase.forgetCases(aux);
                LogFactory.getLog(this.getClass()).info((Object)("Running cycle() " + numberOfCycles));
                this.app.cycle(_case);
                caseBase.learnCases(aux);
                ++numberOfCycles;
                ProgressController.step(this.getClass());
            }
            LogFactory.getLog(this.getClass()).info((Object)"Running postcycle()");
            this.app.postCycle();
            ProgressController.finish(this.getClass());
            t = new Date().getTime() - t;
            report.setTotalTime(t);
            report.setNumberOfCycles(numberOfCycles);
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    protected void prepareCases(CBRCaseBase caseBase) {
        if (this.simConfig != null && this.editMethod != null) {
            this.editCaseBase(caseBase);
        }
    }
}

