/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec13;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.conditionals.DisplayCasesIfNumber;
import jcolibri.extensions.recommendation.navigationByProposing.CriticalUserChoice;
import jcolibri.extensions.recommendation.navigationByProposing.CritiqueOption;
import jcolibri.extensions.recommendation.navigationByProposing.DisplayCasesTableWithCritiquesMethod;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.MoreLikeThis;
import jcolibri.extensions.recommendation.tabuList.TabuList;
import jcolibri.method.gui.formFilling.ObtainQueryWithFormMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.NotEqual;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryLess;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryMore;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryMoreOrEqual;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Threshold;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Table;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaLessIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaMoreIsBetter;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.compromiseDriven.CompromiseDrivenSelection;
import jcolibri.test.recommenders.housesData.HouseDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Houses13
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    NNConfig simConfig;
    Collection<Attribute> hiddenAtts;
    Map<Attribute, String> labels;
    Collection<CritiqueOption> critiques;
    FilterConfig preferences;

    @Override
    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.simConfig = new NNConfig();
        this.simConfig.setDescriptionSimFunction(new Average());
        this.simConfig.addMapping(new Attribute("area", HouseDescription.class), new Table("jcolibri/test/recommenders/housesData/area.csv"));
        this.simConfig.addMapping(new Attribute("beds", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.simConfig.addMapping(new Attribute("price", HouseDescription.class), new InrecaLessIsBetter(2000.0, 0.5));
        this.simConfig.addMapping(new Attribute("furnished", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("type", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("baths", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.hiddenAtts = new ArrayList<Attribute>();
        this.labels = new HashMap<Attribute, String>();
        this.labels.put(new Attribute("beds", HouseDescription.class), "Min bedrooms");
        this.labels.put(new Attribute("price", HouseDescription.class), "Approximate price");
        this.labels.put(new Attribute("baths", HouseDescription.class), "Min bahtrooms");
        this.critiques = new ArrayList<CritiqueOption>();
        this.critiques.add(new CritiqueOption("More Beds", new Attribute("beds", HouseDescription.class), new QueryLess()));
        this.critiques.add(new CritiqueOption("Cheaper", new Attribute("price", HouseDescription.class), new QueryMore()));
        this.critiques.add(new CritiqueOption("More Bathrooms", new Attribute("baths", HouseDescription.class), new QueryLess()));
        this.critiques.add(new CritiqueOption("Change Area", new Attribute("area", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal()));
        this.critiques.add(new CritiqueOption("Another Area", new Attribute("area", HouseDescription.class), new NotEqual()));
        this.preferences = new FilterConfig();
        this.preferences.addPredicate(new Attribute("beds", HouseDescription.class), new QueryMoreOrEqual());
        this.preferences.addPredicate(new Attribute("price", HouseDescription.class), new Threshold(50));
        this.preferences.addPredicate(new Attribute("baths", HouseDescription.class), new QueryMoreOrEqual());
        this.preferences.addPredicate(new Attribute("furnished", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.preferences.addPredicate(new Attribute("type", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        ObtainQueryWithFormMethod.obtainQueryWithInitialValues(query, this.hiddenAtts, this.labels);
        this.sequence1(query, new FilterConfig());
    }

    public void sequence1(CBRQuery query, FilterConfig filterConfig) throws ExecutionException {
        Collection<CBRCase> filtered = FilterBasedRetrievalMethod.filterCases(this._caseBase.getCases(), query, filterConfig);
        Collection<RetrievalResult> retrievedCases = NNScoringMethod.evaluateSimilarity(filtered, query, this.simConfig);
        Collection<CBRCase> selectedCases = CompromiseDrivenSelection.CDR(query, retrievedCases, this.preferences);
        if (DisplayCasesIfNumber.displayCasesWithMessage(Integer.MAX_VALUE, 1, selectedCases = TabuList.removeTabuList(selectedCases))) {
            this.sequence2(selectedCases);
        } else {
            System.exit(0);
        }
    }

    public void sequence2(Collection<CBRCase> selectedCases) throws ExecutionException {
        CriticalUserChoice choice = DisplayCasesTableWithCritiquesMethod.displayCasesInTableWithCritiques(selectedCases, this.critiques, this._caseBase.getCases());
        TabuList.updateTabuList(selectedCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence3(choice.getSelectedCaseAsQuery(), choice);
        } else {
            this.sequence4(choice, selectedCases);
        }
    }

    public void sequence3(CBRQuery query, CriticalUserChoice cuc) throws ExecutionException {
        MoreLikeThis.moreLikeThis(query, cuc.getSelectedCase());
        this.sequence1(query, cuc.getFilterConfig());
    }

    public void sequence4(UserChoice choice, Collection<CBRCase> retrievedCases) throws ExecutionException {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Houses13 recommender = new Houses13();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            hd.setArea(HouseDescription.Area.Hampstead);
            hd.setBaths(1);
            hd.setBeds(HouseDescription.Beds.two);
            hd.setFurnished(true);
            hd.setPrice(500);
            hd.setType(HouseDescription.Type.Flat);
            query.setDescription(hd);
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(Houses13.class).error((Object)e);
        }
    }
}

