/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.maintenance_evaluation;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.evaluation.EvaluationReport;
import jcolibri.method.maintenance.QueryResult;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedEvaluationReport
extends EvaluationReport {
    protected HashMap<String, List<QueryResult>> queryData = new HashMap();

    public List<QueryResult> getQuerySeries(String label) {
        return this.queryData.get(label);
    }

    public void setSeries(String label, List<QueryResult> queryEvaluations) {
        this.queryData.put(label, queryEvaluations);
    }

    public void addDataToSeries(String label, CBRQuery query, Double value) {
        List<QueryResult> queries = this.queryData.get(label);
        if (queries == null) {
            queries = new LinkedList<QueryResult>();
        }
        queries.add(new QueryResult(query, value));
        this.queryData.put(label, queries);
    }

    public String[] getQuerySeriesLabels() {
        Set<String> set = this.queryData.keySet();
        String[] res = new String[set.size()];
        int i = 0;
        for (String e : set) {
            res[i++] = e;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public void printDetailedEvaluationReport(String filename) {
        PrintWriter pw = null;
        try {
            try {
                List<Comparable<Double>> results;
                pw = new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
                pw.println("Results:");
                String[] seriesLabels = this.getSeriesLabels();
                String[] querySeriesLabels = this.getQuerySeriesLabels();
                String[] otherLabels = this.getOtherLabels();
                int i = 0;
                while (i < seriesLabels.length) {
                    void var8_9;
                    pw.println(String.valueOf(seriesLabels[i]) + ":");
                    results = this.getSeries(seriesLabels[i]);
                    String string = "";
                    for (Double d : results) {
                        String string2 = String.valueOf(var8_9) + d + ",";
                    }
                    pw.println(var8_9.substring(0, var8_9.length() - 2));
                    pw.println("Average: " + this.getAverageOfDataSeries(seriesLabels[i]));
                    pw.println();
                    ++i;
                }
                pw.println();
                i = 0;
                while (i < querySeriesLabels.length) {
                    pw.println(String.valueOf(querySeriesLabels[i]) + ":");
                    results = this.getQuerySeries(querySeriesLabels[i]);
                    for (QueryResult queryResult : results) {
                        pw.println(queryResult.getCase().getID() + ": " + queryResult.getResult());
                    }
                    pw.println("Average: " + this.getAverageOfQueryDataSeries(querySeriesLabels[i]));
                    pw.println();
                    ++i;
                }
                pw.println();
                i = 0;
                while (i < otherLabels.length) {
                    pw.println(String.valueOf(otherLabels[i]) + ": " + this.getOtherData(otherLabels[i]));
                    pw.println();
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void removeDataSeries(String label) {
        this.data.remove(label);
    }

    public void removeOtherData(String label) {
        this.other.remove(label);
    }

    public Double getAverageOfDataSeries(String label) {
        Vector v = (Vector)this.data.get(label);
        if (v == null) {
            LogFactory.getLog(this.getClass()).error((Object)"Data series by this label does not exist");
            return null;
        }
        if (v.size() == 0) {
            return 0.0;
        }
        double total = 0.0;
        for (Double value : v) {
            total += value.doubleValue();
        }
        return total / (double)v.size();
    }

    public Double getAverageOfQueryDataSeries(String label) {
        List<QueryResult> results = this.queryData.get(label);
        if (results == null) {
            LogFactory.getLog(this.getClass()).error((Object)"Data series by this label does not exist");
            return null;
        }
        if (results.size() == 0) {
            return 0.0;
        }
        double total = 0.0;
        for (QueryResult result : results) {
            total += result.getResult();
        }
        return total / (double)results.size();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Series:\n");
        String[] series = this.getSeriesLabels();
        int i = 0;
        while (i < series.length) {
            s.append("  " + series[i] + ": \n    ");
            Vector<Double> v = this.getSeries(series[i]);
            for (Double d : v) {
                s.append(d + ",");
            }
            s.append("\n");
            s.append("  Average: " + this.getAverageOfDataSeries(series[i]) + "\n\n");
            ++i;
        }
        s.append("\nOther data:\n");
        String[] other = this.getOtherLabels();
        int i2 = 0;
        while (i2 < other.length) {
            s.append("  " + other[i2] + ": " + this.getOtherData(other[i2]) + "\n");
            ++i2;
        }
        s.append("\nNumber of Cycles: " + this.getNumberOfCycles());
        s.append("\nTime per Cycle:   " + this.getTimePerCycle() + " ms");
        s.append("\nTotal time:       " + this.getTotalTime() + " ms");
        return s.toString();
    }
}

