/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test1;

import java.util.Collection;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.DataBaseConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.database.HSQLDBserver;
import jcolibri.test.test1.TravelDescription;
import jcolibri.util.FileIO;

public class Test1
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new DataBaseConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test1/databaseconfig.xml"));
            this._caseBase = new LinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        NNConfig simConfig = new NNConfig();
        simConfig.setDescriptionSimFunction(new Average());
        simConfig.addMapping(new Attribute("Accomodation", TravelDescription.class), new Equal());
        Attribute duration = new Attribute("Duration", TravelDescription.class);
        simConfig.addMapping(duration, new Interval(31.0));
        simConfig.setWeight(duration, 0.5);
        simConfig.addMapping(new Attribute("HolidayType", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("NumberOfPersons", TravelDescription.class), new Equal());
        simConfig.addMapping(new Attribute("Price", TravelDescription.class), new Interval(4000.0));
        System.out.println("Query Description:");
        System.out.println(query.getDescription());
        System.out.println();
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this._caseBase.getCases(), query, simConfig);
        eval = SelectCases.selectTopKRR(eval, 5);
        System.out.println("Retrieved cases:");
        for (RetrievalResult nse : eval) {
            System.out.println(nse);
        }
    }

    public void postCycle() throws ExecutionException {
        this._caseBase.close();
    }

    public static void main(String[] args) {
        HSQLDBserver.init();
        Test1 test1 = new Test1();
        try {
            test1.configure();
            test1.preCycle();
            TravelDescription queryDesc = new TravelDescription();
            queryDesc.setAccomodation("ThreeStars");
            queryDesc.setDuration(7);
            queryDesc.setHolidayType("Recreation");
            queryDesc.setNumberOfPersons(2);
            queryDesc.setPrice(700);
            CBRQuery query = new CBRQuery();
            query.setDescription(queryDesc);
            test1.cycle(query);
            System.out.println("Cycle finished. Type exit to idem or enter to repeat the cycle");
            test1.postCycle();
            HSQLDBserver.shutDown();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

