/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.gate;

import gate.Annotation;
import gate.Document;
import gate.DocumentFormat;
import gate.Factory;
import java.util.Hashtable;
import jcolibri.extensions.textual.IE.gate.gateinit.InitGate;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Paragraph;
import jcolibri.extensions.textual.IE.representation.Sentence;
import jcolibri.extensions.textual.IE.representation.Token;
import org.apache.commons.logging.LogFactory;

public class IETextGate
extends IEText {
    protected Document doc;
    private Hashtable<Paragraph, Annotation> parMapping = new Hashtable();
    private Hashtable<Sentence, Annotation> sentMapping = new Hashtable();
    private Hashtable<Token, Annotation> tokMapping = new Hashtable();

    public IETextGate() {
        InitGate.initGate();
    }

    public IETextGate(String content) {
        InitGate.initGate();
        try {
            this.fromString(content);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void fromString(String content) throws Exception {
        super.fromString(content);
        this.doc = Factory.newDocument((String)content);
        DocumentFormat df = DocumentFormat.getDocumentFormat((Document)this.doc, (String)"text");
        df.unpackMarkup(this.doc);
    }

    protected Document getDocument() {
        return this.doc;
    }

    protected Annotation getParagraphMapping(Paragraph par) {
        return this.parMapping.get(par);
    }

    protected void setParagraphMapping(Paragraph par, Annotation annot) {
        this.parMapping.put(par, annot);
    }

    protected Annotation getSentenceMapping(Sentence sent) {
        return this.sentMapping.get(sent);
    }

    protected void setSentenceMapping(Sentence sent, Annotation annot) {
        this.sentMapping.put(sent, annot);
    }

    protected Annotation getTokenMapping(Token tok) {
        return this.tokMapping.get(tok);
    }

    protected void setTokenMapping(Token tok, Annotation annot) {
        this.tokMapping.put(tok, annot);
    }
}

