/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local;

import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class Interval
implements LocalSimilarityFunction {
    double _interval;

    public Interval(double interval) {
        this._interval = interval;
    }

    public double compute(Object o1, Object o2) throws NoApplicableSimilarityFunctionException {
        if (o1 == null || o2 == null) {
            return 0.0;
        }
        if (!(o1 instanceof Number)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), o1.getClass());
        }
        if (!(o2 instanceof Number)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), o2.getClass());
        }
        Number i1 = (Number)o1;
        Number i2 = (Number)o2;
        double v1 = i1.doubleValue();
        double v2 = i2.doubleValue();
        return 1.0 - Math.abs(v1 - v2) / this._interval;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Number;
        }
        if (o2 == null) {
            return o1 instanceof Number;
        }
        return o1 instanceof Number && o2 instanceof Number;
    }
}

