/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders;

import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;

public class InrecaLessIsBetter
implements LocalSimilarityFunction {
    double maxValue;
    double jump;

    public InrecaLessIsBetter(double maxAttributeValue, double jumpSimilarity) {
        this.maxValue = maxAttributeValue;
        this.jump = jumpSimilarity;
    }

    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        double max;
        double queryValue;
        double caseValue;
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof Number) && !(caseObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof Number) && !(queryObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        if (caseObject instanceof Number) {
            Number n1 = (Number)caseObject;
            Number n2 = (Number)queryObject;
            caseValue = n1.doubleValue();
            queryValue = n2.doubleValue();
            max = this.maxValue;
        } else {
            Enum enum1 = (Enum)caseObject;
            Enum enum2 = (Enum)queryObject;
            caseValue = enum1.ordinal();
            queryValue = enum2.ordinal();
            max = caseObject.getClass().getEnumConstants().length;
        }
        if (caseValue <= queryValue) {
            return 1.0;
        }
        if (caseValue >= this.maxValue) {
            return 0.0;
        }
        return this.jump * (max - caseValue) / (max - queryValue);
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof Number || o2 instanceof Enum;
        }
        if (o2 == null) {
            return o1 instanceof Number || o1 instanceof Enum;
        }
        return o1 instanceof Number && o2 instanceof Number || o1 instanceof Enum && o2 instanceof Enum;
    }
}

