/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.navigationByAsking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.method.gui.editors.ParameterEditor;
import jcolibri.method.gui.editors.ParameterEditorFactory;
import jcolibri.method.gui.utils.LayoutUtils;
import jcolibri.method.gui.utils.WindowUtils;
import jcolibri.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObtainQueryWithAttributeQuestionMethod {
    private static JDialog dialog;

    public static boolean obtainQueryWithAttributeQuestion(CBRQuery query, Attribute attribute, Map<Attribute, String> labels, Collection<CBRCase> cases) {
        if (attribute == null) {
            return false;
        }
        dialog = new JDialog();
        dialog.setModal(true);
        dialog.setTitle("Enter query value");
        String info = "Please specify following property to focus the retrieval: ";
        Object currentValue = AttributeUtils.findValue(attribute, query);
        if (currentValue != null) {
            info = String.valueOf(info) + "(current value = " + currentValue + ")";
        }
        JLabel infoLabel = new JLabel(info);
        JPanel main = new JPanel();
        main.setLayout(new SpringLayout());
        String label = labels.get(attribute);
        if (label == null) {
            label = attribute.getName();
        }
        main.add(new JLabel(label));
        HashSet<Object> values = new HashSet<Object>();
        for (CBRCase c : cases) {
            values.add(AttributeUtils.findValue(attribute, c));
        }
        ParameterEditor pe = ParameterEditorFactory.getEditor(attribute.getType(), values);
        main.add(pe.getJComponent());
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                dialog.setVisible(false);
            }
        });
        JPanel southPanel = new JPanel();
        southPanel.add(ok);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)infoLabel, "North");
        dialog.getContentPane().add((Component)main, "Center");
        dialog.getContentPane().add((Component)southPanel, "South");
        LayoutUtils.makeCompactGrid(main, 1, 2, 5, 5, 5, 5);
        dialog.pack();
        WindowUtils.centerWindow(dialog);
        dialog.setVisible(true);
        AttributeUtils.setValue(attribute, query, pe.getEditorValue());
        return true;
    }
}

