/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.evaluation.evaluators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.evaluation.EvaluationReport;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoldOutEvaluator
extends Evaluator {
    protected StandardCBRApplication app;

    @Override
    public void init(StandardCBRApplication cbrApp) {
        report = new EvaluationReport();
        this.app = cbrApp;
        try {
            this.app.configure();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void HoldOut(int testPercent, int repetitions) {
        try {
            long t = new Date().getTime();
            int numberOfCycles = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
            CBRCaseBase caseBase = this.app.preCycle();
            if (!(caseBase instanceof CachedLinealCaseBase)) {
                LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
            }
            ArrayList<CBRCase> originalCases = new ArrayList<CBRCase>(caseBase.getCases());
            int totalSteps = originalCases.size() * testPercent / 100;
            ProgressController.init(this.getClass(), "Hold Out Evaluation", totalSteps *= repetitions);
            int rep = 0;
            while (rep < repetitions) {
                ArrayList<CBRCase> querySet = new ArrayList<CBRCase>();
                ArrayList<CBRCase> caseBaseSet = new ArrayList<CBRCase>();
                this.splitCaseBase(originalCases, querySet, caseBaseSet, testPercent);
                caseBase.forgetCases(originalCases);
                caseBase.learnCases(caseBaseSet);
                for (CBRCase c : querySet) {
                    LogFactory.getLog(this.getClass()).info((Object)("Running cycle() " + numberOfCycles));
                    this.app.cycle(c);
                    ProgressController.step(this.getClass());
                    ++numberOfCycles;
                }
                ++rep;
            }
            ProgressController.finish(this.getClass());
            caseBase.forgetCases(originalCases);
            caseBase.learnCases(originalCases);
            LogFactory.getLog(this.getClass()).info((Object)"Running postcycle()");
            this.app.postCycle();
            t = new Date().getTime() - t;
            report.setTotalTime(t);
            report.setNumberOfCycles(numberOfCycles);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    protected void splitCaseBase(Collection<CBRCase> holeCaseBase, List<CBRCase> querySet, List<CBRCase> casebaseSet, int testPercent) {
        querySet.clear();
        casebaseSet.clear();
        int querySetSize = holeCaseBase.size() * testPercent / 100;
        casebaseSet.addAll(holeCaseBase);
        int i = 0;
        while (i < querySetSize) {
            int random = (int)(Math.random() * (double)casebaseSet.size());
            CBRCase _case = casebaseSet.get(random);
            casebaseSet.remove(random);
            querySet.add(_case);
            ++i;
        }
    }
}

