/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE;

import java.util.ArrayList;
import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEutils {
    public static Collection<IEText> getTexts(CBRCase _case) {
        ArrayList<IEText> res = new ArrayList<IEText>();
        IEutils.addTexts(_case.getDescription(), res);
        IEutils.addTexts(_case.getSolution(), res);
        IEutils.addTexts(_case.getJustificationOfSolution(), res);
        IEutils.addTexts(_case.getResult(), res);
        return res;
    }

    public static Collection<IEText> getTexts(CBRQuery query) {
        ArrayList<IEText> res = new ArrayList<IEText>();
        IEutils.addTexts(query.getDescription(), res);
        return res;
    }

    public static void addTexts(CaseComponent cc, Collection<IEText> list) {
        if (cc == null) {
            return;
        }
        Attribute[] attrs = AttributeUtils.getAttributes(cc.getClass());
        int i = 0;
        while (i < attrs.length) {
            try {
                Object o = attrs[i].getValue(cc);
                if (o instanceof IEText) {
                    list.add((IEText)o);
                } else if (o instanceof CaseComponent) {
                    IEutils.addTexts((CaseComponent)o, list);
                }
            }
            catch (AttributeAccessException e) {
                LogFactory.getLog(IEutils.class).error((Object)e);
            }
            ++i;
        }
    }
}

