/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.carrot2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jcolibri.datatypes.Text;
import jcolibri.extensions.textual.carrot2.CarrotClusterer;
import jcolibri.extensions.textual.carrot2.CarrotClusteringResult;
import jcolibri.extensions.textual.lucene.LuceneDocument;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.extensions.textual.wordnet.WordNetBridge;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCarrot {
    private static String CONTENT_FIELD = "content";

    public static void main(String[] args) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogType(0);
        jfc.setFileSelectionMode(1);
        jfc.showOpenDialog(null);
        File docDir = jfc.getSelectedFile();
        if (!docDir.exists() || !docDir.canRead()) {
            System.out.println("Document directory '" + docDir.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            System.exit(1);
        }
        Collection<LuceneDocument> docs = null;
        try {
            docs = TestCarrot.indexDocs(docDir);
        }
        catch (IOException e) {
            LogFactory.getLog(WordNetBridge.class).error((Object)e);
        }
        try {
            LuceneIndex index = new LuceneIndex(docs);
            String[] searchFields = new String[]{CONTENT_FIELD};
            CarrotClusterer clusterer = new CarrotClusterer(index, searchFields, 20);
            String query = JOptionPane.showInputDialog("Query?");
            CarrotClusteringResult ccr = clusterer.cluster(query);
            int i = 0;
            int total = ccr.getClusters().size();
            for (CarrotClusteringResult.Cluster c : ccr.getClusters()) {
                System.out.println("Cluster " + i++ + "/" + total + ": " + c.getLabels());
                System.out.println(String.valueOf(c.getDocs().size()) + " documents in cluster");
                for (LuceneDocument doc : c.getDocs()) {
                    System.out.println("  " + doc.getDocID());
                }
            }
        }
        catch (OutOfMemoryError e) {
            LogFactory.getLog(WordNetBridge.class).error((Object)"Carrot2 requires more memory. Launch the JVM with these flags: java -Xms256m -Xmx512m ...");
        }
    }

    private static Collection<LuceneDocument> indexDocs(File directory) throws IOException {
        File[] files;
        ArrayList<LuceneDocument> docs = new ArrayList<LuceneDocument>();
        if (!directory.canRead()) {
            return docs;
        }
        if (!directory.isDirectory()) {
            return docs;
        }
        File[] fileArray = files = directory.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File f = fileArray[n];
            if (!f.isDirectory()) {
                BufferedReader fr = new BufferedReader(new FileReader(f));
                StringBuffer sb = new StringBuffer();
                while (fr.ready()) {
                    sb.append(fr.readLine());
                }
                fr.close();
                LuceneDocument doc = new LuceneDocument(f.getCanonicalPath());
                doc.addContentField(CONTENT_FIELD, new Text(sb.toString()));
                docs.add(doc);
            }
            ++n;
        }
        return docs;
    }
}

