/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.stemmer;

import java.util.StringTokenizer;
import net.sf.snowball.SnowballProgram;
import net.sf.snowball.ext.danishStemmer;
import net.sf.snowball.ext.dutchStemmer;
import net.sf.snowball.ext.englishStemmer;
import net.sf.snowball.ext.finnishStemmer;
import net.sf.snowball.ext.frenchStemmer;
import net.sf.snowball.ext.germanStemmer;
import net.sf.snowball.ext.italianStemmer;
import net.sf.snowball.ext.norwegianStemmer;
import net.sf.snowball.ext.portugueseStemmer;
import net.sf.snowball.ext.russianStemmer;
import net.sf.snowball.ext.spanishStemmer;
import net.sf.snowball.ext.swedishStemmer;

public class Stemmer {
    private SnowballProgram _stemmer;

    public Stemmer() {
        this(Language.ENGLISH);
    }

    public Stemmer(Language language) {
        this._stemmer = language == Language.DANISH ? new danishStemmer() : (language == Language.DUTCH ? new dutchStemmer() : (language == Language.ENGLISH ? new englishStemmer() : (language == Language.FINNISH ? new finnishStemmer() : (language == Language.FRENCH ? new frenchStemmer() : (language == Language.GERMAN ? new germanStemmer() : (language == Language.ITALIAN ? new italianStemmer() : (language == Language.NORWEGIAN ? new norwegianStemmer() : (language == Language.PORTUGUESE ? new portugueseStemmer() : (language == Language.RUSSIAN ? new russianStemmer() : (language == Language.SPANISH ? new spanishStemmer() : (language == Language.SWEDISH ? new swedishStemmer() : new englishStemmer())))))))))));
    }

    public String stem(String word) {
        if (this._stemmer == null) {
            return word;
        }
        this._stemmer.setCurrent(word.toLowerCase());
        this._stemmer.stem();
        return this._stemmer.getCurrent();
    }

    public String stemSentence(String sentence) {
        StringTokenizer st = new StringTokenizer(sentence, " ");
        StringBuffer res = new StringBuffer();
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            res.append(this.stem(nextToken));
            if (!st.hasMoreTokens()) continue;
            res.append(' ');
        }
        return res.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Language {
        DANISH,
        DUTCH,
        ENGLISH,
        FINNISH,
        FRENCH,
        GERMAN,
        ITALIAN,
        NORWEGIAN,
        PORTUGUESE,
        RUSSIAN,
        SPANISH,
        SWEDISH;

    }
}

