/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec2;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.DataBaseConnector;
import jcolibri.datatypes.Instance;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.method.gui.formFilling.ObtainQueryWithFormMethod;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.EnumCyclicDistance;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Threshold;
import jcolibri.method.retrieve.NNretrieval.similarity.local.ontology.OntCosine;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaLessIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.McSherryMoreIsBetter;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.database.HSQLDBserver;
import jcolibri.test.recommenders.travelData.TravelDescription;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Travel2
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    NNConfig simConfig;
    Collection<Attribute> hiddenAtts;
    Map<Attribute, String> labels;

    @Override
    public void configure() throws ExecutionException {
        HSQLDBserver.init();
        this._connector = new DataBaseConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/travelData/databaseconfig.xml"));
        this._caseBase = new LinealCaseBase();
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        ob.initWithPelletReasoner();
        OntologyDocument mainOnto = new OntologyDocument("http://gaia.fdi.ucm.es/ontologies/travel-destinations.owl", FileIO.findFile("jcolibri/test/recommenders/travelData/travel-destinations.owl").toExternalForm());
        ArrayList subOntologies = new ArrayList();
        ob.loadOntology(mainOnto, subOntologies, false);
        this.simConfig = new NNConfig();
        this.simConfig.setDescriptionSimFunction(new Average());
        this.simConfig.addMapping(new Attribute("HolidayType", TravelDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("NumberOfPersons", TravelDescription.class), new Threshold(2.0));
        this.simConfig.addMapping(new Attribute("Region", TravelDescription.class), new OntCosine());
        this.simConfig.addMapping(new Attribute("Transportation", TravelDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("Duration", TravelDescription.class), new Interval(31.0));
        this.simConfig.addMapping(new Attribute("Season", TravelDescription.class), new EnumCyclicDistance());
        this.simConfig.addMapping(new Attribute("Accommodation", TravelDescription.class), new McSherryMoreIsBetter(0.0, 0.0));
        this.simConfig.addMapping(new Attribute("Price", TravelDescription.class), new InrecaLessIsBetter(4000.0, 0.5));
        this.hiddenAtts = new ArrayList<Attribute>();
        this.hiddenAtts.add(new Attribute("Accommodation", TravelDescription.class));
        this.labels = new HashMap<Attribute, String>();
        this.labels.put(new Attribute("Price", TravelDescription.class), "Max price");
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        ObtainQueryWithFormMethod.obtainQueryWithInitialValues(query, this.hiddenAtts, this.labels);
        this.sequence1(query);
    }

    public void sequence1(CBRQuery query) {
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this._caseBase.getCases(), query, this.simConfig);
        Collection<CBRCase> retrievedCases = SelectCases.selectTopK(eval, 5);
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableEditQuery(retrievedCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence2(query);
        } else {
            this.sequence3(choice, retrievedCases);
        }
    }

    public void sequence2(CBRQuery query) {
        ObtainQueryWithFormMethod.obtainQueryWithInitialValues(query, this.hiddenAtts, this.labels);
        this.sequence1(query);
    }

    public void sequence3(UserChoice choice, Collection<CBRCase> retrievedCases) {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
        this._connector.close();
        HSQLDBserver.shutDown();
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Travel2 recommender = new Travel2();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            TravelDescription td = new TravelDescription();
            td.setAccommodation(TravelDescription.AccommodationTypes.ThreeStars);
            td.setDuration(7);
            td.setHolidayType("bathing");
            td.setNumberOfPersons(2);
            td.setRegion(new Instance("Spain"));
            td.setSeason(TravelDescription.Seasons.July);
            td.setTransportation("plane");
            td.setPrice(1000);
            query.setDescription(td);
            recommender.cycle(query);
            recommender.postCycle();
            System.exit(0);
        }
        catch (Exception e) {
            LogFactory.getLog(Travel2.class).error((Object)e);
        }
    }
}

