/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.evaluation;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationReport {
    private long totalTime;
    private int numberOfCycles;
    protected Hashtable<String, Vector<Double>> data = new Hashtable();
    protected Hashtable<String, String> other = new Hashtable();

    public Vector<Double> getSeries(String label) {
        return this.data.get(label);
    }

    public void setSeries(String label, Vector<Double> evaluation) {
        this.data.put(label, evaluation);
    }

    public void addDataToSeries(String label, Double value) {
        Vector<Double> v = this.data.get(label);
        if (v == null) {
            v = new Vector();
            this.data.put(label, v);
        }
        v.add(value);
    }

    public String[] getSeriesLabels() {
        Set<String> set = this.data.keySet();
        String[] res = new String[set.size()];
        int i = 0;
        for (String e : set) {
            res[i++] = e;
        }
        return res;
    }

    public void putOtherData(String label, String data) {
        this.other.put(label, data);
    }

    public String getOtherData(String label) {
        return this.other.get(label);
    }

    public String[] getOtherLabels() {
        Set<String> set = this.other.keySet();
        String[] res = new String[set.size()];
        int i = 0;
        for (String e : set) {
            res[i++] = e;
        }
        return res;
    }

    public int getNumberOfCycles() {
        return this.numberOfCycles;
    }

    public void setNumberOfCycles(int numberOfCycles) {
        this.numberOfCycles = numberOfCycles;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public double getTimePerCycle() {
        return (double)this.totalTime / (double)this.numberOfCycles;
    }

    public boolean checkData() {
        boolean ok = true;
        int l = -1;
        Enumeration<Vector<Double>> iter = this.data.elements();
        while (iter.hasMoreElements() && ok) {
            Vector<Double> v = iter.nextElement();
            if (l == -1) {
                l = v.size();
                continue;
            }
            boolean bl = ok = l == v.size();
        }
        return ok;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Series:\n");
        String[] series = this.getSeriesLabels();
        int i = 0;
        while (i < series.length) {
            s.append("  " + series[i] + ": \n    ");
            Vector<Double> v = this.getSeries(series[i]);
            for (Double d : v) {
                s.append(d + ",");
            }
            s.append("\n");
            ++i;
        }
        s.append("\nOther data:\n");
        String[] other = this.getOtherLabels();
        int i2 = 0;
        while (i2 < other.length) {
            s.append("  " + other[i2] + ": " + this.getOtherData(other[i2]) + "\n");
            ++i2;
        }
        s.append("\nNumber of Cycles: " + this.getNumberOfCycles());
        s.append("\nTime per Cycle:   " + this.getTimePerCycle() + " ms");
        s.append("\nTotal time:       " + this.getTotalTime() + " ms");
        return s.toString();
    }
}

