/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.gui.editors;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import jcolibri.datatypes.Instance;
import jcolibri.datatypes.Text;
import jcolibri.method.gui.editors.BooleanEditor;
import jcolibri.method.gui.editors.DateEditor;
import jcolibri.method.gui.editors.DoubleEditor;
import jcolibri.method.gui.editors.EnumEditor;
import jcolibri.method.gui.editors.FileEditor;
import jcolibri.method.gui.editors.InstanceEditor;
import jcolibri.method.gui.editors.IntegerEditor;
import jcolibri.method.gui.editors.ParameterEditor;
import jcolibri.method.gui.editors.StringEditor;
import jcolibri.method.gui.editors.TextEditor;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterEditorFactory {
    private static HashMap<Class, Class> table = new HashMap();

    static {
        ParameterEditorFactory.registerEditor(Boolean.class, BooleanEditor.class);
        ParameterEditorFactory.registerEditor(Date.class, DateEditor.class);
        ParameterEditorFactory.registerEditor(Double.class, DoubleEditor.class);
        ParameterEditorFactory.registerEditor(Enum.class, EnumEditor.class);
        ParameterEditorFactory.registerEditor(File.class, FileEditor.class);
        ParameterEditorFactory.registerEditor(Instance.class, InstanceEditor.class);
        ParameterEditorFactory.registerEditor(String.class, StringEditor.class);
        ParameterEditorFactory.registerEditor(Text.class, TextEditor.class);
        ParameterEditorFactory.registerEditor(Integer.class, IntegerEditor.class);
    }

    public static ParameterEditor getEditor(Class<?> type) {
        try {
            Class editor = table.get(type);
            if (editor != null) {
                return (ParameterEditor)table.get(type).newInstance();
            }
            for (Class c : table.keySet()) {
                if (!c.isAssignableFrom(type)) continue;
                editor = table.get(c);
            }
            if (editor.equals(EnumEditor.class)) {
                return new EnumEditor(type);
            }
            if (editor != null) {
                return (ParameterEditor)editor.newInstance();
            }
            throw new Exception("No editor found for type: " + type.getName());
        }
        catch (Exception e) {
            LogFactory.getLog(ParameterEditorFactory.class).error((Object)e);
            return null;
        }
    }

    public static ParameterEditor getEditor(Class<?> type, Collection<Object> allowedValues) {
        ParameterEditor pe = ParameterEditorFactory.getEditor(type);
        if (pe == null) {
            return null;
        }
        pe.setAllowedValues(allowedValues);
        return pe;
    }

    public static void registerEditor(Class type, Class editor) {
        table.put(type, editor);
    }

    public static void unregisterEditor(Class type) {
        table.remove(type);
    }

    public static void clear() {
        table.clear();
    }
}

