/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.precycle;

import java.util.ArrayList;
import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.datatypes.Text;
import jcolibri.extensions.textual.lucene.LuceneDocument;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexCreator {
    public static LuceneIndex createLuceneIndex(CBRCaseBase casebase, Collection<Attribute> fields) {
        for (Attribute field : fields) {
            Class<?> c = field.getType();
            if (Text.class.isAssignableFrom(c)) continue;
            LogFactory.getLog(LuceneIndexCreator.class).error((Object)("Field " + field + " is not an jcolibri.datatyps.Text. Aborting Lucene index creation"));
            return null;
        }
        ArrayList<LuceneDocument> docs = new ArrayList<LuceneDocument>();
        for (CBRCase c : casebase.getCases()) {
            LuceneDocument ld = new LuceneDocument((String)c.getID());
            for (Attribute field : fields) {
                ld.addContentField(field.getName(), (Text)AttributeUtils.findValue(field, c));
            }
            docs.add(ld);
        }
        return new LuceneIndex(docs);
    }

    public static LuceneIndex createLuceneIndex(CBRCaseBase casebase) {
        CBRCase _case = casebase.getCases().iterator().next();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (_case.getDescription() != null) {
            attributes.addAll(AttributeUtils.getAttributes(_case.getDescription(), Text.class));
        }
        if (_case.getSolution() != null) {
            attributes.addAll(AttributeUtils.getAttributes(_case.getSolution(), Text.class));
        }
        if (_case.getResult() != null) {
            attributes.addAll(AttributeUtils.getAttributes(_case.getResult(), Text.class));
        }
        if (_case.getJustificationOfSolution() != null) {
            attributes.addAll(AttributeUtils.getAttributes(_case.getJustificationOfSolution(), Text.class));
        }
        return LuceneIndexCreator.createLuceneIndex(casebase, attributes);
    }
}

